/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.validation.DoubleRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.LongRangeValidatorBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheResourceDefinition;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DistributedCacheResourceDefinition
extends SharedStateCacheResourceDefinition {
    static final PathElement WILDCARD_PATH = DistributedCacheResourceDefinition.pathElement("*");

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"distributed-cache", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (InfinispanModel.VERSION_4_2_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(Attribute.L1_LIFESPAN.getDefinition()), new AttributeDefinition[]{Attribute.L1_LIFESPAN.getDefinition()})).end();
        }
        if (InfinispanModel.VERSION_4_1_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(Attribute.CONSISTENT_HASH_STRATEGY.getDefinition()), new AttributeDefinition[]{Attribute.CONSISTENT_HASH_STRATEGY.getDefinition()})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(Attribute.SEGMENTS.getDefinition()), new AttributeDefinition[]{Attribute.SEGMENTS.getDefinition()})).end();
        }
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{Attribute.CAPACITY_FACTOR.getDefinition().getDefaultValue()}), new AttributeDefinition[]{Attribute.CAPACITY_FACTOR.getDefinition()})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Attribute.CAPACITY_FACTOR.getDefinition()})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(ConsistentHashStrategy.INTRA_CACHE.name())}), new AttributeDefinition[]{Attribute.CONSISTENT_HASH_STRATEGY.getDefinition()})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Attribute.CONSISTENT_HASH_STRATEGY.getDefinition()})).end();
        }
        SharedStateCacheResourceDefinition.buildTransformation(version, builder);
    }

    DistributedCacheResourceDefinition() {
        super(WILDCARD_PATH, descriptor -> descriptor.addAttributes(Attribute.class), new DistributedCacheServiceHandler());
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        CAPACITY_FACTOR("capacity-factor", ModelType.DOUBLE, new ModelNode(1.0), builder -> (SimpleAttributeDefinitionBuilder)builder.setValidator(new DoubleRangeValidatorBuilder().lowerBound(0.0).upperBound(3.4028234663852886E38).configure((AbstractAttributeDefinitionBuilder)builder).build())),
        CONSISTENT_HASH_STRATEGY("consistent-hash-strategy", ModelType.STRING, new ModelNode(ConsistentHashStrategy.INTER_CACHE.name()), builder -> (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(ConsistentHashStrategy.class))),
        L1_LIFESPAN("l1-lifespan", ModelType.LONG, new ModelNode(0L), builder -> (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setValidator(new LongRangeValidatorBuilder().min(0L).configure((AbstractAttributeDefinitionBuilder)builder).build())),
        OWNERS("owners", ModelType.INT, new ModelNode(2), builder -> (SimpleAttributeDefinitionBuilder)builder.setValidator(new IntRangeValidatorBuilder().min(1).configure((AbstractAttributeDefinitionBuilder)builder).build())),
        SEGMENTS("segments", ModelType.INT, new ModelNode(256), builder -> (SimpleAttributeDefinitionBuilder)builder.setValidator(new IntRangeValidatorBuilder().min(1).configure((AbstractAttributeDefinitionBuilder)builder).build()));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue, UnaryOperator<SimpleAttributeDefinitionBuilder> configurator) {
            this.definition = ((SimpleAttributeDefinitionBuilder)configurator.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

