/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.remoting.transport.Transport;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.ChannelFactoryTransport;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class JGroupsTransportBuilder
extends ComponentBuilder<TransportConfiguration>
implements ResourceServiceBuilder<TransportConfiguration> {
    private final String containerName;
    private volatile ValueDependency<ChannelFactory> factory;
    private volatile String channel;
    private volatile long lockTimeout;

    public JGroupsTransportBuilder(PathAddress containerAddress) {
        super(CacheContainerComponent.TRANSPORT, containerAddress);
        this.containerName = containerAddress.getLastElement().getValue();
    }

    @Override
    public ServiceBuilder<TransportConfiguration> build(ServiceTarget target) {
        return this.factory.register(super.build(target));
    }

    public JGroupsTransportBuilder configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.lockTimeout = JGroupsTransportResourceDefinition.Attribute.LOCK_TIMEOUT.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.channel = ModelNodes.optionalString((ModelNode)JGroupsTransportResourceDefinition.Attribute.CHANNEL.resolveModelAttribute((ExpressionResolver)context, model)).orElse(null);
        this.factory = new InjectedValueDependency(JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, this.channel), ChannelFactory.class);
        return this;
    }

    public TransportConfiguration getValue() {
        ChannelFactory factory = (ChannelFactory)this.factory.getValue();
        ProtocolStackConfiguration stack = factory.getProtocolStackConfiguration();
        TransportConfiguration.Topology topology = stack.getTransport().getTopology();
        TransportConfigurationBuilder builder = new GlobalConfigurationBuilder().transport().clusterName(this.containerName).distributedSyncTimeout(this.lockTimeout).transport((Transport)new ChannelFactoryTransport(factory));
        if (topology != null) {
            builder.siteId(topology.getSite()).rackId(topology.getRack()).machineId(topology.getMachine());
        }
        return builder.create();
    }

    String getChannel() {
        return this.channel;
    }
}

