/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.security.PrivilegedAction;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.filter.KeyFilter;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.ee.infinispan.RetryingInvoker;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.CancelSchedulerCommand;
import org.wildfly.clustering.web.infinispan.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.ScheduleSchedulerCommand;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.infinispan.session.SessionEvictionScheduler;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleImmutableSession;
import org.wildfly.clustering.web.session.ImmutableHttpSessionAdapter;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(primaryOnly=true)
public class InfinispanSessionManager<MV, AV, L>
implements SessionManager<L, TransactionBatch> {
    private final SessionExpirationListener expirationListener;
    private final Batcher<TransactionBatch> batcher;
    private final Cache<Key<String>, ?> cache;
    private final CacheProperties properties;
    private final SessionFactory<MV, AV, L> factory;
    private final IdentifierFactory<String> identifierFactory;
    private final CommandDispatcherFactory dispatcherFactory;
    private final NodeFactory<Address> nodeFactory;
    private final int maxActiveSessions;
    private volatile Duration defaultMaxInactiveInterval = Duration.ofMinutes(30L);
    private final Invoker invoker = new RetryingInvoker(new long[]{0L, 10L, 100L});
    private final SessionCreationMetaDataKeyFilter filter = new SessionCreationMetaDataKeyFilter();
    private final Locality locality;
    private final Recordable<ImmutableSession> recorder;
    private final ServletContext context;
    private final AtomicReference<Future<?>> rehashFuture = new AtomicReference();
    private volatile CommandDispatcher<Scheduler> dispatcher;
    private volatile Scheduler scheduler;
    private volatile ExecutorService executor;

    private static ThreadFactory createThreadFactory() {
        PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(new ThreadGroup(InfinispanSessionManager.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
        return (ThreadFactory)WildFlySecurityManager.doUnchecked(action);
    }

    public InfinispanSessionManager(SessionFactory<MV, AV, L> factory, InfinispanSessionManagerConfiguration configuration) {
        this.factory = factory;
        this.cache = configuration.getCache();
        this.locality = new ConsistentHashLocality(this.cache);
        this.properties = configuration.getProperties();
        this.expirationListener = configuration.getExpirationListener();
        this.identifierFactory = configuration.getIdentifierFactory();
        this.batcher = configuration.getBatcher();
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.nodeFactory = configuration.getNodeFactory();
        this.maxActiveSessions = configuration.getMaxActiveSessions();
        this.recorder = configuration.getInactiveSessionRecorder();
        this.context = configuration.getServletContext();
    }

    public void start() {
        this.executor = Executors.newSingleThreadExecutor(InfinispanSessionManager.createThreadFactory());
        if (this.recorder != null) {
            this.recorder.reset();
        }
        this.identifierFactory.start();
        final ArrayList<Scheduler> schedulers = new ArrayList<Scheduler>(2);
        schedulers.add(new SessionExpirationScheduler(this.batcher, new ExpiredSessionRemover<MV, AV, L>(this.factory, this.expirationListener)));
        if (this.maxActiveSessions >= 0) {
            schedulers.add(new SessionEvictionScheduler(this.cache.getName() + ".eviction", this.factory, this.batcher, this.dispatcherFactory, this.maxActiveSessions));
        }
        this.scheduler = new Scheduler(){

            @Override
            public void schedule(String sessionId, ImmutableSessionMetaData metaData) {
                schedulers.forEach(scheduler -> scheduler.schedule(sessionId, metaData));
            }

            @Override
            public void cancel(String sessionId) {
                schedulers.forEach(scheduler -> scheduler.cancel(sessionId));
            }

            @Override
            public void cancel(Locality locality) {
                schedulers.forEach(scheduler -> scheduler.cancel(locality));
            }

            @Override
            public void close() {
                schedulers.forEach(scheduler -> scheduler.close());
            }
        };
        this.dispatcher = this.dispatcherFactory.createCommandDispatcher((Object)(this.cache.getName() + ".schedulers"), (Object)this.scheduler);
        this.cache.addListener((Object)this, (KeyFilter)this.filter);
        this.schedule((Locality)new SimpleLocality(false), this.locality);
    }

    public void stop() {
        this.cache.removeListener((Object)this);
        PrivilegedAction<List> action = () -> this.executor.shutdownNow();
        WildFlySecurityManager.doUnchecked(action);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.dispatcher.close();
            this.scheduler.close();
            this.identifierFactory.stop();
        }
    }

    boolean isPersistent() {
        return this.properties.isPersistent();
    }

    private void cancel(String sessionId) {
        try {
            this.executeOnPrimaryOwner(sessionId, new CancelSchedulerCommand(sessionId));
        }
        catch (Exception e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToCancelSession(e, sessionId);
        }
    }

    void schedule(String sessionId, ImmutableSessionMetaData metaData) {
        try {
            this.executeOnPrimaryOwner(sessionId, new ScheduleSchedulerCommand(sessionId, metaData));
        }
        catch (Exception e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToScheduleSession(e, sessionId);
        }
    }

    private void executeOnPrimaryOwner(String sessionId, Command<Void, Scheduler> command) throws Exception {
        ((CommandResponse)this.invoker.invoke(() -> {
            Node node = this.locatePrimaryOwner(sessionId);
            return this.dispatcher.executeOnNode(command, node);
        })).get();
    }

    private Node locatePrimaryOwner(String sessionId) {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        Address address = dist != null ? dist.getPrimaryLocation((Object)new Key((Object)sessionId)) : null;
        return address != null ? this.nodeFactory.createNode((Object)address) : this.dispatcherFactory.getGroup().getLocalNode();
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public Duration getDefaultMaxInactiveInterval() {
        return this.defaultMaxInactiveInterval;
    }

    public void setDefaultMaxInactiveInterval(Duration duration) {
        this.defaultMaxInactiveInterval = duration;
    }

    public String createIdentifier() {
        return (String)this.identifierFactory.createIdentifier();
    }

    public Session<L> findSession(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue(id);
        if (value == null) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s not found", id);
            return null;
        }
        ImmutableSession session = this.factory.createImmutableSession(id, value);
        if (session.getMetaData().isExpired()) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was found, but has expired", id);
            this.expirationListener.sessionExpired(session);
            this.factory.remove(id);
            return null;
        }
        this.cancel(id);
        if (this.properties.isPersistent()) {
            this.triggerPostActivationEvents(session);
        }
        return new SchedulableSession(this.factory.createSession(id, value), session);
    }

    public Session<L> createSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.createValue(id, null);
        if (entry == null) {
            return null;
        }
        Session<L> session = this.factory.createSession(id, entry);
        session.getMetaData().setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        return new SchedulableSession(session, (ImmutableSession)session);
    }

    public ImmutableSession viewSession(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue(id);
        return value != null ? new SimpleImmutableSession(this.factory.createImmutableSession(id, value)) : null;
    }

    public Set<String> getActiveSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD);
    }

    public Set<String> getLocalSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL);
    }

    private Set<String> getSessions(Flag ... flags) {
        try (CacheStream keys = this.cache.getAdvancedCache().withFlags(flags).keySet().stream();){
            Set<String> set = keys.filter(this.filter.and(key -> this.locality.isLocal(key))).map(key -> (String)key.getValue()).collect(Collectors.toSet());
            return set;
        }
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public long getActiveSessionCount() {
        return this.getActiveSessions().size();
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<SessionCreationMetaDataKey, ?> event) {
        if (!event.isPre() && !this.properties.isPersistent()) {
            String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getValue();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was activated", id);
            Map.Entry value = (Map.Entry)this.factory.findValue(id);
            if (value != null) {
                ImmutableSession session = this.factory.createImmutableSession(id, value);
                this.triggerPostActivationEvents(session);
            }
        }
    }

    @CacheEntryPassivated
    public void passivated(CacheEntryPassivatedEvent<SessionCreationMetaDataKey, ?> event) {
        if (event.isPre() && !this.properties.isPersistent()) {
            String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getValue();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be passivated", id);
            Map.Entry value = (Map.Entry)this.factory.findValue(id);
            if (value != null) {
                ImmutableSession session = this.factory.createImmutableSession(id, value);
                this.triggerPrePassivationEvents(session);
            }
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<SessionCreationMetaDataKey, ?> event) {
        if (event.isPre()) {
            String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getValue();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be removed", id);
            Map.Entry value = (Map.Entry)this.factory.findValue(id);
            if (value != null) {
                ImmutableSession session = this.factory.createImmutableSession(id, value);
                ImmutableSessionAttributes attributes = session.getAttributes();
                ImmutableHttpSessionAdapter httpSession = new ImmutableHttpSessionAdapter(session, this.context);
                for (String name : attributes.getAttributeNames()) {
                    Object attribute = attributes.getAttribute(name);
                    if (!(attribute instanceof HttpSessionBindingListener)) continue;
                    HttpSessionBindingListener listener = (HttpSessionBindingListener)attribute;
                    listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)httpSession, name, attribute));
                }
                if (this.recorder != null) {
                    this.recorder.record((Object)session);
                }
            }
        }
    }

    @DataRehashed
    public void dataRehashed(DataRehashedEvent<SessionCreationMetaDataKey, ?> event) {
        Cache cache = event.getCache();
        Address localAddress = cache.getCacheManager().getAddress();
        ConsistentHashLocality newLocality = new ConsistentHashLocality(localAddress, event.getConsistentHashAtEnd());
        if (event.isPre()) {
            Future future = this.rehashFuture.getAndSet(null);
            if (future != null) {
                future.cancel(true);
            }
            try {
                this.executor.submit(() -> this.lambda$dataRehashed$5((Locality)newLocality));
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        } else {
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(localAddress, event.getConsistentHashAtStart());
            try {
                this.rehashFuture.set(this.executor.submit(() -> this.lambda$dataRehashed$6((Locality)oldLocality, (Locality)newLocality)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void schedule(Locality oldLocality, Locality newLocality) {
        SessionMetaDataFactory<MV, L> metaDataFactory = this.factory.getMetaDataFactory();
        Throwable throwable = null;
        try (Stream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).keySet().stream().filter((Predicate)this.filter);){
            Iterator keys = stream.iterator();
            while (keys.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Key key = (Key)keys.next();
                if (!this.filter.test(key) || oldLocality.isLocal((Object)key) || !newLocality.isLocal((Object)key)) continue;
                String id = (String)key.getValue();
                Batch batch = this.batcher.createBatch();
                Throwable throwable2 = null;
                try {
                    Object value = metaDataFactory.tryValue(id);
                    if (value == null) return;
                    this.scheduler.schedule(id, metaDataFactory.createImmutableSessionMetaData(id, value));
                    return;
                }
                catch (CacheException e) {
                    batch.discard();
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (batch == null) continue;
                    if (throwable2 != null) {
                        try {
                            batch.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    batch.close();
                    continue;
                }
                {
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                        return;
                    }
                }
            }
        }
    }

    void triggerPrePassivationEvents(ImmutableSession session) {
        List<HttpSessionActivationListener> listeners = InfinispanSessionManager.findListeners(session);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session, this.context));
            listeners.forEach(listener -> listener.sessionWillPassivate(event));
        }
    }

    void triggerPostActivationEvents(ImmutableSession session) {
        List<HttpSessionActivationListener> listeners = InfinispanSessionManager.findListeners(session);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session, this.context));
            listeners.forEach(listener -> listener.sessionDidActivate(event));
        }
    }

    private static List<HttpSessionActivationListener> findListeners(ImmutableSession session) {
        ImmutableSessionAttributes attributes = session.getAttributes();
        return attributes.getAttributeNames().stream().map(name -> attributes.getAttribute(name)).filter(attribute -> attribute instanceof HttpSessionActivationListener).map(attribute -> (HttpSessionActivationListener)attribute).collect(Collectors.toList());
    }

    private /* synthetic */ void lambda$dataRehashed$6(Locality oldLocality, Locality newLocality) {
        this.schedule(oldLocality, newLocality);
    }

    private /* synthetic */ void lambda$dataRehashed$5(Locality newLocality) {
        this.scheduler.cancel(newLocality);
    }

    private class SchedulableSession
    implements Session<L> {
        private final Session<L> session;
        private final ImmutableSession immutableSession;

        SchedulableSession(Session<L> session, ImmutableSession immutableSession) {
            this.session = session;
            this.immutableSession = immutableSession;
        }

        public String getId() {
            return this.session.getId();
        }

        public SessionMetaData getMetaData() {
            if (!this.session.isValid()) {
                throw InfinispanWebLogger.ROOT_LOGGER.invalidSession(this.getId());
            }
            return this.session.getMetaData();
        }

        public boolean isValid() {
            return this.session.isValid();
        }

        public void invalidate() {
            if (!this.session.isValid()) {
                throw InfinispanWebLogger.ROOT_LOGGER.invalidSession(this.getId());
            }
            this.session.invalidate();
        }

        public SessionAttributes getAttributes() {
            if (!this.session.isValid()) {
                throw InfinispanWebLogger.ROOT_LOGGER.invalidSession(this.getId());
            }
            return this.session.getAttributes();
        }

        public void close() {
            boolean valid = this.session.isValid();
            if (valid && InfinispanSessionManager.this.isPersistent()) {
                InfinispanSessionManager.this.triggerPrePassivationEvents(this.immutableSession);
            }
            this.session.close();
            if (valid) {
                InfinispanSessionManager.this.schedule(this.immutableSession.getId(), this.immutableSession.getMetaData());
            }
        }

        public L getLocalContext() {
            return this.session.getLocalContext();
        }
    }
}

