/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.RemoteEJBReceiver;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

final class RemotingEJBDiscoveryProvider
implements DiscoveryProvider {
    static final RemotingEJBDiscoveryProvider INSTANCE = new RemotingEJBDiscoveryProvider();
    private static final Set<String> JUST_EJB_MODULE = Collections.singleton("ejb-module");
    private static final Set<String> JUST_EJB_MODULE_DISTINCT = Collections.singleton("ejb-module-distinct");
    private static final Set<String> JUST_ATTR_CLUSTER = Collections.singleton("cluster");
    private static final Set<String> JUST_ATTR_NODE = Collections.singleton("node");

    private RemotingEJBDiscoveryProvider() {
        Endpoint.getCurrent();
    }

    public DiscoveryRequest discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult result) {
        if (!serviceType.implies(ServiceType.of((String)"ejb", (String)"jboss"))) {
            result.complete();
            return DiscoveryRequest.NULL;
        }
        EJBClientContext ejbClientContext = EJBClientContext.getCurrent();
        RemoteEJBReceiver ejbReceiver = ejbClientContext.getAttachment(RemoteTransportProvider.ATTACHMENT_KEY);
        if (ejbReceiver == null) {
            result.complete();
            return DiscoveryRequest.NULL;
        }
        if (!(filterSpec.mayMatch(JUST_EJB_MODULE) || filterSpec.mayMatch(JUST_EJB_MODULE_DISTINCT) || filterSpec.mayMatch(JUST_ATTR_CLUSTER) || filterSpec.mayMatch(JUST_ATTR_NODE))) {
            result.complete();
            return DiscoveryRequest.NULL;
        }
        final DiscoveryAttempt discoveryAttempt = new DiscoveryAttempt(serviceType, filterSpec, result, ejbReceiver, AuthenticationContext.captureCurrent());
        for (EJBClientConnection connection : ejbClientContext.getConfiguredConnections()) {
            discoveryAttempt.connectAndDiscover(connection);
        }
        DiscoveryRequest firstRequest = discoveryAttempt.getClusterProvider().discover(serviceType, FilterSpec.hasAttribute((String)"node"), new DiscoveryResult(){

            public void complete() {
                discoveryAttempt.countDown();
            }

            public void reportProblem(Throwable description) {
                discoveryAttempt.reportProblem(description);
            }

            public void addMatch(ServiceURL serviceURL) {
                EJBClientConnection.Builder nodeConnectionBuilder = new EJBClientConnection.Builder();
                nodeConnectionBuilder.setDestination(serviceURL.getLocationURI());
                discoveryAttempt.connectAndDiscover(nodeConnectionBuilder.build());
            }
        });
        discoveryAttempt.onCancel(() -> ((DiscoveryRequest)firstRequest).cancel());
        return discoveryAttempt;
    }

    static final class DiscoveryAttempt
    implements DiscoveryRequest,
    DiscoveryResult {
        private final ServiceType serviceType;
        private final FilterSpec filterSpec;
        private final DiscoveryResult discoveryResult;
        private final RemoteEJBReceiver ejbReceiver;
        private final AuthenticationContext authenticationContext;
        private final Endpoint endpoint;
        private final DiscoveryProvider clusterProvider;
        private final AtomicInteger outstandingCount = new AtomicInteger(1);
        private final List<Runnable> cancellers = Collections.synchronizedList(new ArrayList());
        private final IoFuture.HandlingNotifier<ConnectionPeerIdentity, Void> outerNotifier;
        private final IoFuture.HandlingNotifier<EJBClientChannel, Void> innerNotifier;

        DiscoveryAttempt(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult discoveryResult, RemoteEJBReceiver ejbReceiver, AuthenticationContext authenticationContext) {
            this.serviceType = serviceType;
            this.filterSpec = filterSpec;
            this.discoveryResult = discoveryResult;
            this.ejbReceiver = ejbReceiver;
            this.clusterProvider = ejbReceiver.getRemoteTransportProvider().getClusterDiscoveryProvider();
            this.authenticationContext = authenticationContext;
            this.endpoint = Endpoint.getCurrent();
            this.outerNotifier = new IoFuture.HandlingNotifier<ConnectionPeerIdentity, Void>(){

                public void handleCancelled(Void nothing) {
                    this.countDown();
                }

                public void handleFailed(IOException exception, Void nothing) {
                    discoveryResult.reportProblem((Throwable)exception);
                    this.countDown();
                }

                public void handleDone(ConnectionPeerIdentity data, Void nothing) {
                    IoFuture future = ((DiscoveryAttempt)this).ejbReceiver.serviceHandle.getClientService(data.getConnection(), OptionMap.EMPTY);
                    this.onCancel(() -> ((IoFuture)future).cancel());
                    future.addNotifier((IoFuture.Notifier)innerNotifier, null);
                }
            };
            this.innerNotifier = new IoFuture.HandlingNotifier<EJBClientChannel, Void>(){

                public void handleCancelled(Void nothing) {
                    this.countDown();
                }

                public void handleFailed(IOException exception, Void nothing) {
                    discoveryResult.reportProblem((Throwable)exception);
                    this.countDown();
                }

                public void handleDone(EJBClientChannel clientChannel, Void nothing) {
                    DiscoveryRequest request = clientChannel.getDiscoveryProvider().discover(serviceType, filterSpec, (DiscoveryResult)this);
                    this.onCancel(() -> ((DiscoveryRequest)request).cancel());
                }
            };
        }

        void connectAndDiscover(EJBClientConnection connection) {
            if (!connection.isForDiscovery()) {
                return;
            }
            URI uri = connection.getDestination();
            String scheme = uri.getScheme();
            if (scheme == null || !this.ejbReceiver.getRemoteTransportProvider().supportsProtocol(scheme) || !this.endpoint.isValidUriScheme(scheme)) {
                return;
            }
            this.outstandingCount.getAndIncrement();
            IoFuture future = AccessController.doPrivileged(() -> this.endpoint.getConnectedIdentity(uri, "ejb", "jboss", this.authenticationContext));
            this.onCancel(() -> ((IoFuture)future).cancel());
            future.addNotifier(this.outerNotifier, null);
        }

        void countDown() {
            if (this.outstandingCount.decrementAndGet() == 0) {
                this.clusterProvider.discover(this.serviceType, this.filterSpec, this.discoveryResult);
            }
        }

        DiscoveryProvider getClusterProvider() {
            return this.clusterProvider;
        }

        public void complete() {
            this.countDown();
        }

        public void reportProblem(Throwable description) {
            this.discoveryResult.reportProblem(description);
        }

        public void addMatch(ServiceURL serviceURL) {
            this.discoveryResult.addMatch(serviceURL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            List<Runnable> cancellers;
            List<Runnable> list = cancellers = this.cancellers;
            synchronized (list) {
                for (Runnable canceller : cancellers) {
                    canceller.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onCancel(Runnable action) {
            List<Runnable> cancellers;
            List<Runnable> list = cancellers = this.cancellers;
            synchronized (list) {
                cancellers.add(action);
            }
        }
    }
}

