/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryStatisticsData {
    private static final Comparator<QueryEntry> QUERY_ENTRY_COMPARATOR = new Comparator<QueryEntry>(){

        @Override
        public int compare(QueryEntry o1, QueryEntry o2) {
            return (int)Math.signum(o1.lastUpdateTime - o2.lastUpdateTime);
        }
    };
    private final HashMap<String, QueryEntry> map = new HashMap();
    private int maxQueryEntries;

    public QueryStatisticsData(int maxQueryEntries) {
        this.maxQueryEntries = maxQueryEntries;
    }

    public synchronized void setMaxQueryEntries(int maxQueryEntries) {
        this.maxQueryEntries = maxQueryEntries;
    }

    public synchronized List<QueryEntry> getQueries() {
        ArrayList<QueryEntry> list = new ArrayList<QueryEntry>();
        list.addAll(this.map.values());
        Collections.sort(list, QUERY_ENTRY_COMPARATOR);
        return list.subList(0, Math.min(list.size(), this.maxQueryEntries));
    }

    public synchronized void update(String sqlStatement, long executionTimeNanos, int rowCount) {
        QueryEntry entry = this.map.get(sqlStatement);
        if (entry == null) {
            entry = new QueryEntry();
            entry.sqlStatement = sqlStatement;
            this.map.put(sqlStatement, entry);
        }
        entry.update(executionTimeNanos, rowCount);
        if ((float)this.map.size() > (float)this.maxQueryEntries * 1.5f) {
            ArrayList<QueryEntry> list = new ArrayList<QueryEntry>();
            list.addAll(this.map.values());
            Collections.sort(list, QUERY_ENTRY_COMPARATOR);
            HashSet oldestSet = new HashSet(list.subList(0, list.size() / 3));
            Iterator<Map.Entry<String, QueryEntry>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, QueryEntry> mapEntry = it.next();
                if (!oldestSet.contains(mapEntry.getValue())) continue;
                it.remove();
            }
        }
    }

    public static final class QueryEntry {
        public String sqlStatement;
        public int count;
        public long lastUpdateTime;
        public long executionTimeMinNanos;
        public long executionTimeMaxNanos;
        public long executionTimeCumulativeNanos;
        public int rowCountMin;
        public int rowCountMax;
        public long rowCountCumulative;
        public double executionTimeMeanNanos;
        public double rowCountMean;
        private double executionTimeM2Nanos;
        private double rowCountM2;

        void update(long timeNanos, int rows) {
            ++this.count;
            this.executionTimeMinNanos = Math.min(timeNanos, this.executionTimeMinNanos);
            this.executionTimeMaxNanos = Math.max(timeNanos, this.executionTimeMaxNanos);
            this.rowCountMin = Math.min(rows, this.rowCountMin);
            this.rowCountMax = Math.max(rows, this.rowCountMax);
            double rowDelta = (double)rows - this.rowCountMean;
            this.rowCountMean += rowDelta / (double)this.count;
            this.rowCountM2 += rowDelta * ((double)rows - this.rowCountMean);
            double timeDelta = (double)timeNanos - this.executionTimeMeanNanos;
            this.executionTimeMeanNanos += timeDelta / (double)this.count;
            this.executionTimeM2Nanos += timeDelta * ((double)timeNanos - this.executionTimeMeanNanos);
            this.executionTimeCumulativeNanos += timeNanos;
            this.rowCountCumulative += (long)rows;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public double getExecutionTimeStandardDeviation() {
            return Math.sqrt(this.executionTimeM2Nanos / (double)this.count);
        }

        public double getRowCountStandardDeviation() {
            return Math.sqrt(this.rowCountM2 / (double)this.count);
        }
    }
}

