/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.expression.ExpressionColumn;
import org.h2.fulltext.FullText;
import org.h2.jdbc.JdbcConnection;
import org.h2.store.fs.FileUtils;
import org.h2.tools.SimpleResultSet;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class FullTextLucene
extends FullText {
    protected static final boolean STORE_DOCUMENT_TEXT_IN_INDEX = Utils.getProperty("h2.storeDocumentTextInIndex", false);
    private static final HashMap<String, IndexAccess> INDEX_ACCESS = New.hashMap();
    private static final String TRIGGER_PREFIX = "FTL_";
    private static final String SCHEMA = "FTL";
    private static final String LUCENE_FIELD_DATA = "_DATA";
    private static final String LUCENE_FIELD_QUERY = "_QUERY";
    private static final String LUCENE_FIELD_MODIFIED = "_modified";
    private static final String LUCENE_FIELD_COLUMN_PREFIX = "_";
    private static final String IN_MEMORY_PREFIX = "mem:";

    public static void init(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA IF NOT EXISTS FTL");
        stat.execute("CREATE TABLE IF NOT EXISTS FTL.INDEXES(SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, PRIMARY KEY(SCHEMA, TABLE))");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_CREATE_INDEX FOR \"" + FullTextLucene.class.getName() + ".createIndex\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_DROP_INDEX FOR \"" + FullTextLucene.class.getName() + ".dropIndex\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH FOR \"" + FullTextLucene.class.getName() + ".search\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH_DATA FOR \"" + FullTextLucene.class.getName() + ".searchData\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_REINDEX FOR \"" + FullTextLucene.class.getName() + ".reindex\"");
        stat.execute("CREATE ALIAS IF NOT EXISTS FTL_DROP_ALL FOR \"" + FullTextLucene.class.getName() + ".dropAll\"");
        try {
            FullTextLucene.getIndexAccess(conn);
        }
        catch (SQLException e) {
            throw FullTextLucene.convertException(e);
        }
    }

    public static void createIndex(Connection conn, String schema, String table, String columnList) throws SQLException {
        FullTextLucene.init(conn);
        PreparedStatement prep = conn.prepareStatement("INSERT INTO FTL.INDEXES(SCHEMA, TABLE, COLUMNS) VALUES(?, ?, ?)");
        prep.setString(1, schema);
        prep.setString(2, table);
        prep.setString(3, columnList);
        prep.execute();
        FullTextLucene.createTrigger(conn, schema, table);
        FullTextLucene.indexExistingRows(conn, schema, table);
    }

    public static void dropIndex(Connection conn, String schema, String table) throws SQLException {
        FullTextLucene.init(conn);
        PreparedStatement prep = conn.prepareStatement("DELETE FROM FTL.INDEXES WHERE SCHEMA=? AND TABLE=?");
        prep.setString(1, schema);
        prep.setString(2, table);
        int rowCount = prep.executeUpdate();
        if (rowCount == 0) {
            return;
        }
        FullTextLucene.reindex(conn);
    }

    public static void reindex(Connection conn) throws SQLException {
        FullTextLucene.init(conn);
        FullTextLucene.removeAllTriggers(conn, TRIGGER_PREFIX);
        FullTextLucene.removeIndexFiles(conn);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM FTL.INDEXES");
        while (rs.next()) {
            String schema = rs.getString("SCHEMA");
            String table = rs.getString("TABLE");
            FullTextLucene.createTrigger(conn, schema, table);
            FullTextLucene.indexExistingRows(conn, schema, table);
        }
    }

    public static void dropAll(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("DROP SCHEMA IF EXISTS FTL");
        FullTextLucene.removeAllTriggers(conn, TRIGGER_PREFIX);
        FullTextLucene.removeIndexFiles(conn);
    }

    public static ResultSet search(Connection conn, String text, int limit, int offset) throws SQLException {
        return FullTextLucene.search(conn, text, limit, offset, false);
    }

    public static ResultSet searchData(Connection conn, String text, int limit, int offset) throws SQLException {
        return FullTextLucene.search(conn, text, limit, offset, true);
    }

    protected static SQLException convertException(Exception e) {
        SQLException e2 = new SQLException("Error while indexing document", "FULLTEXT");
        e2.initCause(e);
        return e2;
    }

    protected static void createTrigger(Connection conn, String schema, String table) throws SQLException {
        FullTextLucene.createOrDropTrigger(conn, schema, table, true);
    }

    private static void createOrDropTrigger(Connection conn, String schema, String table, boolean create) throws SQLException {
        Statement stat = conn.createStatement();
        String trigger = StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + table);
        stat.execute("DROP TRIGGER IF EXISTS " + trigger);
        if (create) {
            StringBuilder buff = new StringBuilder("CREATE TRIGGER IF NOT EXISTS ");
            buff.append(trigger).append(" AFTER INSERT, UPDATE, DELETE, ROLLBACK ON ").append(StringUtils.quoteIdentifier(schema)).append('.').append(StringUtils.quoteIdentifier(table)).append(" FOR EACH ROW CALL \"").append(FullTextTrigger.class.getName()).append('\"');
            stat.execute(buff.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IndexAccess getIndexAccess(Connection conn) throws SQLException {
        String path = FullTextLucene.getIndexPath(conn);
        HashMap<String, IndexAccess> hashMap = INDEX_ACCESS;
        synchronized (hashMap) {
            IndexAccess access = INDEX_ACCESS.get(path);
            if (access == null) {
                try {
                    RAMDirectory indexDir = path.startsWith(IN_MEMORY_PREFIX) ? new RAMDirectory() : FSDirectory.open((File)new File(path));
                    StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_30);
                    IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_30, (Analyzer)analyzer);
                    conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                    IndexWriter writer = new IndexWriter((Directory)indexDir, conf);
                    IndexReader reader = IndexReader.open((IndexWriter)writer, (boolean)true);
                    access = new IndexAccess();
                    access.writer = writer;
                    access.reader = reader;
                    access.searcher = new IndexSearcher(reader);
                }
                catch (IOException e) {
                    throw FullTextLucene.convertException(e);
                }
                INDEX_ACCESS.put(path, access);
            }
            return access;
        }
    }

    protected static String getIndexPath(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("CALL DATABASE_PATH()");
        rs.next();
        String path = rs.getString(1);
        if (path == null) {
            return IN_MEMORY_PREFIX + conn.getCatalog();
        }
        int index = path.lastIndexOf(58);
        if (index > 1) {
            path = path.substring(index + 1);
        }
        rs.close();
        return path;
    }

    protected static void indexExistingRows(Connection conn, String schema, String table) throws SQLException {
        FullTextTrigger existing = new FullTextTrigger();
        existing.init(conn, schema, null, table, false, 1);
        String sql = "SELECT * FROM " + StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(table);
        ResultSet rs = conn.createStatement().executeQuery(sql);
        int columnCount = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                row[i] = rs.getObject(i + 1);
            }
            existing.insert(row, false);
        }
        existing.commitIndex();
    }

    private static void removeIndexFiles(Connection conn) throws SQLException {
        String path = FullTextLucene.getIndexPath(conn);
        IndexAccess access = INDEX_ACCESS.get(path);
        if (access != null) {
            FullTextLucene.removeIndexAccess(access, path);
        }
        if (!path.startsWith(IN_MEMORY_PREFIX)) {
            FileUtils.deleteRecursive(path, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeIndexAccess(IndexAccess access, String indexPath) throws SQLException {
        HashMap<String, IndexAccess> hashMap = INDEX_ACCESS;
        synchronized (hashMap) {
            try {
                INDEX_ACCESS.remove(indexPath);
                access.searcher.close();
                access.reader.close();
                access.writer.close();
            }
            catch (Exception e) {
                throw FullTextLucene.convertException(e);
            }
        }
    }

    protected static ResultSet search(Connection conn, String text, int limit, int offset, boolean data) throws SQLException {
        SimpleResultSet result = FullTextLucene.createResultSet(data);
        if (conn.getMetaData().getURL().startsWith("jdbc:columnlist:")) {
            return result;
        }
        if (text == null || text.trim().length() == 0) {
            return result;
        }
        try {
            IndexAccess access = FullTextLucene.getIndexAccess(conn);
            IndexSearcher searcher = access.searcher;
            Analyzer analyzer = access.writer.getAnalyzer();
            QueryParser parser = new QueryParser(Version.LUCENE_30, LUCENE_FIELD_DATA, analyzer);
            Query query = parser.parse(text);
            int maxResults = (limit == 0 ? 100 : limit) + offset;
            TopDocs docs = searcher.search(query, maxResults);
            if (limit == 0) {
                limit = docs.totalHits;
            }
            int len = docs.scoreDocs.length;
            for (int i = 0; i < limit && i + offset < docs.totalHits && i + offset < len; ++i) {
                ScoreDoc sd = docs.scoreDocs[i + offset];
                Document doc = searcher.doc(sd.doc);
                float score = sd.score;
                String q = doc.get(LUCENE_FIELD_QUERY);
                if (data) {
                    int idx = q.indexOf(" WHERE ");
                    JdbcConnection c = (JdbcConnection)conn;
                    Session session = (Session)c.getSession();
                    Parser p = new Parser(session);
                    String tab = q.substring(0, idx);
                    ExpressionColumn expr = (ExpressionColumn)p.parseExpression(tab);
                    String schemaName = expr.getOriginalTableAliasName();
                    String tableName = expr.getColumnName();
                    q = q.substring(idx + " WHERE ".length());
                    Object[][] columnData = FullTextLucene.parseKey(conn, q);
                    result.addRow(schemaName, tableName, columnData[0], columnData[1], Float.valueOf(score));
                    continue;
                }
                result.addRow(q, Float.valueOf(score));
            }
        }
        catch (Exception e) {
            throw FullTextLucene.convertException(e);
        }
        return result;
    }

    static class IndexAccess {
        IndexWriter writer;
        IndexReader reader;
        IndexSearcher searcher;

        IndexAccess() {
        }
    }

    public static class FullTextTrigger
    implements Trigger {
        protected String schema;
        protected String table;
        protected int[] keys;
        protected int[] indexColumns;
        protected String[] columns;
        protected int[] columnTypes;
        protected String indexPath;
        protected IndexAccess indexAccess;

        @Override
        public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
            String cols;
            this.schema = schemaName;
            this.table = tableName;
            this.indexPath = FullTextLucene.getIndexPath(conn);
            this.indexAccess = FullTextLucene.getIndexAccess(conn);
            ArrayList<String> keyList = New.arrayList();
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns(null, StringUtils.escapeMetaDataPattern(schemaName), StringUtils.escapeMetaDataPattern(tableName), null);
            ArrayList<String> columnList = New.arrayList();
            while (rs.next()) {
                columnList.add(rs.getString("COLUMN_NAME"));
            }
            this.columnTypes = new int[columnList.size()];
            this.columns = new String[columnList.size()];
            columnList.toArray(this.columns);
            rs = meta.getColumns(null, StringUtils.escapeMetaDataPattern(schemaName), StringUtils.escapeMetaDataPattern(tableName), null);
            int i = 0;
            while (rs.next()) {
                this.columnTypes[i] = rs.getInt("DATA_TYPE");
                ++i;
            }
            if (keyList.size() == 0) {
                rs = meta.getPrimaryKeys(null, StringUtils.escapeMetaDataPattern(schemaName), tableName);
                while (rs.next()) {
                    keyList.add(rs.getString("COLUMN_NAME"));
                }
            }
            if (keyList.size() == 0) {
                throw FullText.throwException("No primary key for table " + tableName);
            }
            ArrayList<String> indexList = New.arrayList();
            PreparedStatement prep = conn.prepareStatement("SELECT COLUMNS FROM FTL.INDEXES WHERE SCHEMA=? AND TABLE=?");
            prep.setString(1, schemaName);
            prep.setString(2, tableName);
            rs = prep.executeQuery();
            if (rs.next() && (cols = rs.getString(1)) != null) {
                for (String s : StringUtils.arraySplit(cols, ',', true)) {
                    indexList.add(s);
                }
            }
            if (indexList.size() == 0) {
                indexList.addAll(columnList);
            }
            this.keys = new int[keyList.size()];
            FullText.setColumns(this.keys, keyList, columnList);
            this.indexColumns = new int[indexList.size()];
            FullText.setColumns(this.indexColumns, indexList, columnList);
        }

        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (oldRow != null) {
                if (newRow != null) {
                    if (FullText.hasChanged(oldRow, newRow, this.indexColumns)) {
                        this.delete(oldRow, false);
                        this.insert(newRow, true);
                    }
                } else {
                    this.delete(oldRow, true);
                }
            } else if (newRow != null) {
                this.insert(newRow, true);
            }
        }

        @Override
        public void close() throws SQLException {
            if (this.indexAccess != null) {
                FullTextLucene.removeIndexAccess(this.indexAccess, this.indexPath);
                this.indexAccess = null;
            }
        }

        @Override
        public void remove() {
        }

        void commitIndex() throws SQLException {
            try {
                this.indexAccess.writer.commit();
                this.indexAccess.searcher.close();
                this.indexAccess.reader.close();
                this.indexAccess.reader = IndexReader.open((IndexWriter)this.indexAccess.writer, (boolean)true);
                this.indexAccess.searcher = new IndexSearcher(this.indexAccess.reader);
            }
            catch (IOException e) {
                throw FullTextLucene.convertException(e);
            }
        }

        protected void insert(Object[] row, boolean commitIndex) throws SQLException {
            String query = this.getQuery(row);
            Document doc = new Document();
            doc.add((Fieldable)new Field(FullTextLucene.LUCENE_FIELD_QUERY, query, Field.Store.YES, Field.Index.NOT_ANALYZED));
            long time = System.currentTimeMillis();
            doc.add((Fieldable)new Field(FullTextLucene.LUCENE_FIELD_MODIFIED, DateTools.timeToString((long)time, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.NOT_ANALYZED));
            StatementBuilder buff = new StatementBuilder();
            for (int index : this.indexColumns) {
                String columnName = this.columns[index];
                String data = FullText.asString(row[index], this.columnTypes[index]);
                if (columnName.startsWith(FullTextLucene.LUCENE_FIELD_COLUMN_PREFIX)) {
                    columnName = FullTextLucene.LUCENE_FIELD_COLUMN_PREFIX + columnName;
                }
                doc.add((Fieldable)new Field(columnName, data, Field.Store.NO, Field.Index.ANALYZED));
                buff.appendExceptFirst(" ");
                buff.append(data);
            }
            Field.Store storeText = STORE_DOCUMENT_TEXT_IN_INDEX ? Field.Store.YES : Field.Store.NO;
            doc.add((Fieldable)new Field(FullTextLucene.LUCENE_FIELD_DATA, buff.toString(), storeText, Field.Index.ANALYZED));
            try {
                this.indexAccess.writer.addDocument(doc);
                if (commitIndex) {
                    this.commitIndex();
                }
            }
            catch (IOException e) {
                throw FullTextLucene.convertException(e);
            }
        }

        protected void delete(Object[] row, boolean commitIndex) throws SQLException {
            String query = this.getQuery(row);
            try {
                Term term = new Term(FullTextLucene.LUCENE_FIELD_QUERY, query);
                this.indexAccess.writer.deleteDocuments(term);
                if (commitIndex) {
                    this.commitIndex();
                }
            }
            catch (IOException e) {
                throw FullTextLucene.convertException(e);
            }
        }

        private String getQuery(Object[] row) throws SQLException {
            StatementBuilder buff = new StatementBuilder();
            if (this.schema != null) {
                buff.append(StringUtils.quoteIdentifier(this.schema)).append('.');
            }
            buff.append(StringUtils.quoteIdentifier(this.table)).append(" WHERE ");
            for (int columnIndex : this.keys) {
                buff.appendExceptFirst(" AND ");
                buff.append(StringUtils.quoteIdentifier(this.columns[columnIndex]));
                Object o = row[columnIndex];
                if (o == null) {
                    buff.append(" IS NULL");
                    continue;
                }
                buff.append('=').append(FullText.quoteSQL(o, this.columnTypes[columnIndex]));
            }
            return buff.toString();
        }
    }
}

