/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitInputStream
extends FilterInputStream {
    private long remaining;

    public LimitInputStream(InputStream in, long maxLength) {
        super(in);
        this.remaining = maxLength;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.remaining, (long)this.in.available());
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int result = this.in.read();
        if (result >= 0) {
            --this.remaining;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int result = this.in.read(b, off, len = (int)Math.min((long)len, this.remaining));
        if (result >= 0) {
            this.remaining -= (long)result;
        }
        return result;
    }
}

