/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.h2.compress.CompressLZF;
import org.h2.util.MathUtils;

class FileNioMemData {
    private static final int CACHE_SIZE = 8;
    private static final int BLOCK_SIZE_SHIFT = 16;
    private static final int BLOCK_SIZE = 65536;
    private static final int BLOCK_SIZE_MASK = 65535;
    private static final CompressLZF LZF = new CompressLZF();
    private static final byte[] BUFFER = new byte[131072];
    private static final ByteBuffer COMPRESSED_EMPTY_BLOCK;
    private static final Cache<CompressItem, CompressItem> COMPRESS_LATER;
    private String name;
    private final int id;
    private final boolean compress;
    private long length;
    private ByteBuffer[] data;
    private long lastModified;
    private boolean isReadOnly;
    private boolean isLockedExclusive;
    private int sharedLockCount;

    FileNioMemData(String name, boolean compress) {
        this.name = name;
        this.id = name.hashCode();
        this.compress = compress;
        this.data = new ByteBuffer[0];
        this.lastModified = System.currentTimeMillis();
    }

    int getId() {
        return this.id;
    }

    synchronized boolean lockExclusive() {
        if (this.sharedLockCount > 0 || this.isLockedExclusive) {
            return false;
        }
        this.isLockedExclusive = true;
        return true;
    }

    synchronized boolean lockShared() {
        if (this.isLockedExclusive) {
            return false;
        }
        ++this.sharedLockCount;
        return true;
    }

    synchronized void unlock() {
        if (this.isLockedExclusive) {
            this.isLockedExclusive = false;
        } else {
            this.sharedLockCount = Math.max(0, this.sharedLockCount - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressLater(int page) {
        CompressItem c = new CompressItem();
        c.data = this;
        c.page = page;
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            COMPRESS_LATER.put(c, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(int page) {
        ByteBuffer d = this.data[page];
        if (d.capacity() == 65536) {
            return;
        }
        ByteBuffer out = ByteBuffer.allocateDirect(65536);
        if (d != COMPRESSED_EMPTY_BLOCK) {
            CompressLZF compressLZF = LZF;
            synchronized (compressLZF) {
                d.position(0);
                CompressLZF.expand(d, out);
            }
        }
        this.data[page] = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compress(int page) {
        ByteBuffer d = this.data[page];
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            int len = LZF.compress(d, 0, BUFFER, 0);
            d = ByteBuffer.allocateDirect(len);
            d.put(BUFFER, 0, len);
            this.data[page] = d;
        }
    }

    void touch(boolean openReadOnly) throws IOException {
        if (this.isReadOnly || openReadOnly) {
            throw new IOException("Read only");
        }
        this.lastModified = System.currentTimeMillis();
    }

    long length() {
        return this.length;
    }

    void truncate(long newLength) {
        this.changeLength(newLength);
        long end = MathUtils.roundUpLong(newLength, 65536L);
        if (end != newLength) {
            int lastPage = (int)(newLength >>> 16);
            this.expand(lastPage);
            ByteBuffer d = this.data[lastPage];
            for (int i = (int)(newLength & 0xFFFFL); i < 65536; ++i) {
                d.put(i, (byte)0);
            }
            if (this.compress) {
                this.compressLater(lastPage);
            }
        }
    }

    private void changeLength(long len) {
        this.length = len;
        int blocks = (int)((len = MathUtils.roundUpLong(len, 65536L)) >>> 16);
        if (blocks != this.data.length) {
            ByteBuffer[] n = new ByteBuffer[blocks];
            System.arraycopy(this.data, 0, n, 0, Math.min(this.data.length, n.length));
            for (int i = this.data.length; i < blocks; ++i) {
                n[i] = COMPRESSED_EMPTY_BLOCK;
            }
            this.data = n;
        }
    }

    long readWrite(long pos, ByteBuffer b, int off, int len, boolean write) {
        long end = pos + (long)len;
        if (end > this.length) {
            if (write) {
                this.changeLength(end);
            } else {
                len = (int)(this.length - pos);
            }
        }
        while (len > 0) {
            ByteBuffer tmp;
            int l = (int)Math.min((long)len, 65536L - (pos & 0xFFFFL));
            int page = (int)(pos >>> 16);
            this.expand(page);
            ByteBuffer block = this.data[page];
            int blockOffset = (int)(pos & 0xFFFFL);
            if (write) {
                tmp = b.slice();
                tmp.position(off);
                tmp.limit(off + l);
                block.position(blockOffset);
                block.put(tmp);
            } else {
                tmp = block.duplicate();
                tmp.position(blockOffset);
                tmp.limit(l + blockOffset);
                int oldPosition = b.position();
                b.position(off);
                b.put(tmp);
                b.position(oldPosition);
            }
            if (this.compress) {
                this.compressLater(page);
            }
            off += l;
            pos += (long)l;
            len -= l;
        }
        return pos;
    }

    void setName(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    long getLastModified() {
        return this.lastModified;
    }

    boolean canWrite() {
        return !this.isReadOnly;
    }

    boolean setReadOnly() {
        this.isReadOnly = true;
        return true;
    }

    static {
        COMPRESS_LATER = new Cache(8);
        byte[] n = new byte[65536];
        int len = LZF.compress(n, 65536, BUFFER, 0);
        COMPRESSED_EMPTY_BLOCK = ByteBuffer.allocateDirect(len);
        COMPRESSED_EMPTY_BLOCK.put(BUFFER, 0, len);
    }

    static class CompressItem {
        FileNioMemData data;
        int page;

        CompressItem() {
        }

        public int hashCode() {
            return this.page ^ this.data.getId();
        }

        public boolean equals(Object o) {
            if (o instanceof CompressItem) {
                CompressItem c = (CompressItem)o;
                return c.data == this.data && c.page == this.page;
            }
            return false;
        }
    }

    static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int size;

        Cache(int size) {
            super(size, 0.75f, true);
            this.size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() < this.size) {
                return false;
            }
            CompressItem c = (CompressItem)eldest.getKey();
            c.data.compress(c.page);
            return true;
        }
    }
}

