/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ViewIndex;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public class TableView
extends Table {
    private static final long ROW_COUNT_APPROXIMATION = 100L;
    private String querySQL;
    private ArrayList<Table> tables;
    private Column[] columnTemplates;
    private Query viewQuery;
    private ViewIndex index;
    private boolean recursive;
    private DbException createException;
    private long lastModificationCheck;
    private long maxDataModificationId;
    private User owner;
    private Query topQuery;
    private LocalResult recursiveResult;
    private boolean tableExpression;

    public TableView(Schema schema, int id, String name, String querySQL, ArrayList<Parameter> params, Column[] columnTemplates, Session session, boolean recursive) {
        super(schema, id, name, false, true);
        this.init(querySQL, params, columnTemplates, session, recursive);
    }

    public void replace(String querySQL, String[] columnNames, Session session, boolean recursive, boolean force) {
        String oldQuerySQL = this.querySQL;
        Column[] oldColumnTemplates = this.columnTemplates;
        boolean oldRecursive = this.recursive;
        this.init(querySQL, null, this.columnTemplates, session, recursive);
        DbException e = this.recompile(session, force, true);
        if (e != null) {
            this.init(oldQuerySQL, null, oldColumnTemplates, session, oldRecursive);
            this.recompile(session, true, false);
            throw e;
        }
    }

    private synchronized void init(String querySQL, ArrayList<Parameter> params, Column[] columnTemplates, Session session, boolean recursive) {
        this.querySQL = querySQL;
        this.columnTemplates = columnTemplates;
        this.recursive = recursive;
        this.index = new ViewIndex(this, querySQL, params, recursive);
        this.initColumnsAndTables(session);
    }

    private static Query compileViewQuery(Session session, String sql) {
        Prepared p;
        session.setParsingView(true);
        try {
            p = session.prepare(sql);
        }
        finally {
            session.setParsingView(false);
        }
        if (!(p instanceof Query)) {
            throw DbException.getSyntaxError(sql, 0);
        }
        return (Query)p;
    }

    public synchronized DbException recompile(Session session, boolean force, boolean clearIndexCache) {
        block6: {
            try {
                TableView.compileViewQuery(session, this.querySQL);
            }
            catch (DbException e) {
                if (force) break block6;
                return e;
            }
        }
        ArrayList<TableView> views = this.getViews();
        if (views != null) {
            views = New.arrayList(views);
        }
        this.initColumnsAndTables(session);
        if (views != null) {
            for (TableView v : views) {
                DbException e = v.recompile(session, force, false);
                if (e == null || force) continue;
                return e;
            }
        }
        if (clearIndexCache) {
            TableView.clearIndexCaches(this.database);
        }
        return force ? null : this.createException;
    }

    private void initColumnsAndTables(Session session) {
        Column[] cols;
        block12: {
            this.removeViewFromTables();
            try {
                Query query = TableView.compileViewQuery(session, this.querySQL);
                this.querySQL = query.getPlanSQL();
                this.tables = New.arrayList(query.getTables());
                ArrayList<Expression> expressions = query.getExpressions();
                ArrayList<Column> list = New.arrayList();
                int count = query.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    Expression checkExpression;
                    Expression aliasExpr;
                    Expression expr = expressions.get(i);
                    String name = null;
                    int type = -1;
                    if (this.columnTemplates != null && this.columnTemplates.length > i) {
                        name = this.columnTemplates[i].getName();
                        type = this.columnTemplates[i].getType();
                    }
                    if (name == null) {
                        name = expr.getAlias();
                    }
                    if (type == -1) {
                        type = expr.getType();
                    }
                    long precision = expr.getPrecision();
                    int scale = expr.getScale();
                    int displaySize = expr.getDisplaySize();
                    Column col = new Column(name, type, precision, scale, displaySize);
                    col.setTable(this, i);
                    ExpressionColumn fromColumn = null;
                    if (expr instanceof ExpressionColumn) {
                        fromColumn = (ExpressionColumn)expr;
                    } else if (expr instanceof Alias && (aliasExpr = expr.getNonAliasExpression()) instanceof ExpressionColumn) {
                        fromColumn = (ExpressionColumn)aliasExpr;
                    }
                    if (fromColumn != null && (checkExpression = fromColumn.getColumn().getCheckConstraint(session, name)) != null) {
                        col.addCheckConstraint(session, checkExpression);
                    }
                    list.add(col);
                }
                cols = new Column[list.size()];
                list.toArray(cols);
                this.createException = null;
                this.viewQuery = query;
            }
            catch (DbException e) {
                e.addSQL(this.getCreateSQL());
                this.createException = e;
                this.tables = New.arrayList();
                cols = new Column[]{};
                if (!this.recursive || this.columnTemplates == null) break block12;
                cols = new Column[this.columnTemplates.length];
                for (int i = 0; i < this.columnTemplates.length; ++i) {
                    cols[i] = this.columnTemplates[i].getClone();
                }
                this.index.setRecursive(true);
                this.createException = null;
            }
        }
        this.setColumns(cols);
        if (this.getId() != 0) {
            this.addViewToTables();
        }
    }

    @Override
    public boolean isView() {
        return true;
    }

    public boolean isInvalid() {
        return this.createException != null;
    }

    @Override
    public PlanItem getBestPlanItem(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        CacheKey cacheKey = new CacheKey(masks, this);
        Map<Object, ViewIndex> indexCache = session.getViewIndexCache(this.topQuery != null);
        ViewIndex i = indexCache.get(cacheKey);
        if (i == null || i.isExpired()) {
            i = new ViewIndex(this, this.index, session, masks, filters, filter, sortOrder);
            indexCache.put(cacheKey, i);
        }
        PlanItem item = new PlanItem();
        item.cost = i.getCost(session, masks, filters, filter, sortOrder, allColumnsSet);
        item.setIndex(i);
        return item;
    }

    @Override
    public boolean isQueryComparable() {
        if (!super.isQueryComparable()) {
            return false;
        }
        for (Table t : this.tables) {
            if (t.isQueryComparable()) continue;
            return false;
        }
        return this.topQuery == null || this.topQuery.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR);
    }

    public Query getTopQuery() {
        return this.topQuery;
    }

    @Override
    public String getDropSQL() {
        return "DROP VIEW IF EXISTS " + this.getSQL() + " CASCADE";
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.getCreateSQL(false, true, quotedName);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean orReplace, boolean force) {
        return this.getCreateSQL(orReplace, force, this.getSQL());
    }

    private String getCreateSQL(boolean orReplace, boolean force, String quotedName) {
        StatementBuilder buff = new StatementBuilder("CREATE ");
        if (orReplace) {
            buff.append("OR REPLACE ");
        }
        if (force) {
            buff.append("FORCE ");
        }
        buff.append("VIEW ");
        buff.append(quotedName);
        if (this.comment != null) {
            buff.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        if (this.columns != null && this.columns.length > 0) {
            buff.append('(');
            for (Column c : this.columns) {
                buff.appendExceptFirst(", ");
                buff.append(c.getSQL());
            }
            buff.append(')');
        } else if (this.columnTemplates != null) {
            buff.append('(');
            for (Column c : this.columnTemplates) {
                buff.appendExceptFirst(", ");
                buff.append(c.getName());
            }
            buff.append(')');
        }
        return buff.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session s) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public String getTableType() {
        return "VIEW";
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.removeViewFromTables();
        super.removeChildrenAndResources(session);
        this.database.removeMeta(session, this.getId());
        this.querySQL = null;
        this.index = null;
        TableView.clearIndexCaches(this.database);
        this.invalidate();
    }

    public static void clearIndexCaches(Database database) {
        for (Session s : database.getSessions(true)) {
            s.clearViewIndexCache();
        }
    }

    @Override
    public String getSQL() {
        if (this.isTemporary()) {
            return "(\n" + StringUtils.indent(this.querySQL) + ")";
        }
        return super.getSQL();
    }

    public String getQuery() {
        return this.querySQL;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.getBestPlanItem(session, null, null, -1, null, null).getIndex();
    }

    @Override
    public Index getScanIndex(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        if (this.createException != null) {
            String msg = this.createException.getMessage();
            throw DbException.get(90109, this.createException, this.getSQL(), msg);
        }
        PlanItem item = this.getBestPlanItem(session, masks, filters, filter, sortOrder, allColumnsSet);
        return item.getIndex();
    }

    @Override
    public boolean canReference() {
        return false;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null) {
            return Long.MAX_VALUE;
        }
        if (this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        long dbMod = this.database.getModificationDataId();
        if (dbMod > this.lastModificationCheck && this.maxDataModificationId <= dbMod) {
            this.maxDataModificationId = this.viewQuery.getMaxDataModificationId();
            this.lastModificationCheck = dbMod;
        }
        return this.maxDataModificationId;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    private void removeViewFromTables() {
        if (this.tables != null) {
            for (Table t : this.tables) {
                t.removeView(this);
            }
            this.tables.clear();
        }
    }

    private void addViewToTables() {
        for (Table t : this.tables) {
            t.addView(this);
        }
    }

    private void setOwner(User owner) {
        this.owner = owner;
    }

    public User getOwner() {
        return this.owner;
    }

    public static TableView createTempView(Session session, User owner, String name, Query query, Query topQuery) {
        Schema mainSchema = session.getDatabase().getSchema("PUBLIC");
        String querySQL = query.getPlanSQL();
        TableView v = new TableView(mainSchema, 0, name, querySQL, query.getParameters(), null, session, false);
        if (v.createException != null) {
            throw v.createException;
        }
        v.setTopQuery(topQuery);
        v.setOwner(owner);
        v.setTemporary(true);
        return v;
    }

    private void setTopQuery(Query topQuery) {
        this.topQuery = topQuery;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public int getParameterOffset(ArrayList<Parameter> additionalParameters) {
        int result;
        int n = result = this.topQuery == null ? -1 : TableView.getMaxParameterIndex(this.topQuery.getParameters());
        if (additionalParameters != null) {
            result = Math.max(result, TableView.getMaxParameterIndex(additionalParameters));
        }
        return result + 1;
    }

    private static int getMaxParameterIndex(ArrayList<Parameter> parameters) {
        int result = -1;
        for (Parameter p : parameters) {
            result = Math.max(result, p.getIndex());
        }
        return result;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public boolean isDeterministic() {
        if (this.recursive || this.viewQuery == null) {
            return false;
        }
        return this.viewQuery.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR);
    }

    public void setRecursiveResult(LocalResult value) {
        if (this.recursiveResult != null) {
            this.recursiveResult.close();
        }
        this.recursiveResult = value;
    }

    public LocalResult getRecursiveResult() {
        return this.recursiveResult;
    }

    public void setTableExpression(boolean tableExpression) {
        this.tableExpression = tableExpression;
    }

    public boolean isTableExpression() {
        return this.tableExpression;
    }

    @Override
    public void addDependencies(HashSet<DbObject> dependencies) {
        super.addDependencies(dependencies);
        if (this.tables != null) {
            for (Table t : this.tables) {
                if ("VIEW".equals(t.getTableType())) continue;
                t.addDependencies(dependencies);
            }
        }
    }

    private static final class CacheKey {
        private final int[] masks;
        private final TableView view;

        public CacheKey(int[] masks, TableView view) {
            this.masks = masks;
            this.view = view;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.masks);
            result = 31 * result + this.view.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.view != other.view) {
                return false;
            }
            return Arrays.equals(this.masks, other.masks);
        }
    }
}

