/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueGeometry
extends Value {
    private final byte[] bytes;
    private final int hashCode;
    private Geometry geometry;

    private ValueGeometry(byte[] bytes, Geometry geometry) {
        this.bytes = bytes;
        this.geometry = geometry;
        this.hashCode = Arrays.hashCode(bytes);
    }

    public static ValueGeometry getFromGeometry(Object o) {
        return ValueGeometry.get((Geometry)o);
    }

    private static ValueGeometry get(Geometry g) {
        byte[] bytes = ValueGeometry.convertToWKB(g);
        return (ValueGeometry)Value.cache(new ValueGeometry(bytes, g));
    }

    private static byte[] convertToWKB(Geometry g) {
        boolean includeSRID = g.getSRID() != 0;
        int dimensionCount = ValueGeometry.getDimensionCount(g);
        WKBWriter writer = new WKBWriter(dimensionCount, includeSRID);
        return writer.write(g);
    }

    private static int getDimensionCount(Geometry geometry) {
        ZVisitor finder = new ZVisitor();
        geometry.apply((CoordinateSequenceFilter)finder);
        return finder.isFoundZ() ? 3 : 2;
    }

    public static ValueGeometry get(String s) {
        try {
            Geometry g = new WKTReader().read(s);
            return ValueGeometry.get(g);
        }
        catch (ParseException ex) {
            throw DbException.convert(ex);
        }
    }

    public static ValueGeometry get(String s, int srid) {
        try {
            GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
            Geometry g = new WKTReader(geometryFactory).read(s);
            return ValueGeometry.get(g);
        }
        catch (ParseException ex) {
            throw DbException.convert(ex);
        }
    }

    public static ValueGeometry get(byte[] bytes) {
        return (ValueGeometry)Value.cache(new ValueGeometry(bytes, null));
    }

    public Geometry getGeometry() {
        return (Geometry)this.getGeometryNoCopy().clone();
    }

    public Geometry getGeometryNoCopy() {
        if (this.geometry == null) {
            try {
                this.geometry = new WKBReader().read(this.bytes);
            }
            catch (ParseException ex) {
                throw DbException.convert(ex);
            }
        }
        return this.geometry;
    }

    public boolean intersectsBoundingBox(ValueGeometry r) {
        return this.getGeometryNoCopy().getEnvelopeInternal().intersects(r.getGeometryNoCopy().getEnvelopeInternal());
    }

    public Value getEnvelopeUnion(ValueGeometry r) {
        GeometryFactory gf = new GeometryFactory();
        Envelope mergedEnvelope = new Envelope(this.getGeometryNoCopy().getEnvelopeInternal());
        mergedEnvelope.expandToInclude(r.getGeometryNoCopy().getEnvelopeInternal());
        return ValueGeometry.get(gf.toGeometry(mergedEnvelope));
    }

    @Override
    public int getType() {
        return 22;
    }

    @Override
    public String getSQL() {
        return "X'" + StringUtils.convertBytesToHex(this.getBytesNoCopy()) + "'::Geometry";
    }

    @Override
    protected int compareSecure(Value v, CompareMode mode) {
        Geometry g = ((ValueGeometry)v).getGeometryNoCopy();
        return this.getGeometryNoCopy().compareTo((Object)g);
    }

    @Override
    public String getString() {
        return this.getWKT();
    }

    @Override
    public long getPrecision() {
        return 0L;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Object getObject() {
        return this.getGeometry();
    }

    @Override
    public byte[] getBytes() {
        return this.getWKB();
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.getWKB();
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setObject(parameterIndex, this.getGeometryNoCopy());
    }

    @Override
    public int getDisplaySize() {
        return this.getWKT().length();
    }

    @Override
    public int getMemory() {
        return this.getWKB().length * 20 + 24;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueGeometry && Arrays.equals(this.getWKB(), ((ValueGeometry)other).getWKB());
    }

    public String getWKT() {
        return new WKTWriter(3).write(this.getGeometryNoCopy());
    }

    public byte[] getWKB() {
        return this.bytes;
    }

    @Override
    public Value convertTo(int targetType) {
        if (targetType == 19) {
            return this;
        }
        return super.convertTo(targetType);
    }

    static class ZVisitor
    implements CoordinateSequenceFilter {
        boolean foundZ;

        ZVisitor() {
        }

        public boolean isFoundZ() {
            return this.foundZ;
        }

        public void filter(CoordinateSequence coordinateSequence, int i) {
            if (!Double.isNaN(coordinateSequence.getOrdinate(i, 2))) {
                this.foundZ = true;
            }
        }

        public boolean isDone() {
            return this.foundZ;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

