/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueShort
extends Value {
    static final int PRECISION = 5;
    static final int DISPLAY_SIZE = 6;
    private final short value;

    private ValueShort(short value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueShort other = (ValueShort)v;
        return ValueShort.checkRange(this.value + other.value);
    }

    private static ValueShort checkRange(int x) {
        if (x < Short.MIN_VALUE || x > Short.MAX_VALUE) {
            throw DbException.get(22003, Integer.toString(x));
        }
        return ValueShort.get((short)x);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueShort.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueShort other = (ValueShort)v;
        return ValueShort.checkRange(this.value - other.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueShort other = (ValueShort)v;
        return ValueShort.checkRange(this.value * other.value);
    }

    @Override
    public Value divide(Value v) {
        ValueShort other = (ValueShort)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.get((short)(this.value / other.value));
    }

    @Override
    public Value modulus(Value v) {
        ValueShort other = (ValueShort)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.get((short)(this.value % other.value));
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueShort v = (ValueShort)o;
        return MathUtils.compareInt(this.value, v.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 5L;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setShort(parameterIndex, this.value);
    }

    public static ValueShort get(short i) {
        return (ValueShort)Value.cache(new ValueShort(i));
    }

    @Override
    public int getDisplaySize() {
        return 6;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueShort && this.value == ((ValueShort)other).value;
    }
}

