/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.HttpClientMessages;

public class HttpClientMessages_$logger
extends DelegatingBasicLogger
implements Serializable,
BasicLogger,
HttpClientMessages {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HttpClientMessages_$logger.class.getName();
    private static final String portValueOutOfRange = "WFHTTP000002: Port value %s out of range";
    private static final String failedToAcquireSession = "WFHTTP000003: Failed to acquire session";
    private static final String invalidResponseType = "WFHTTP000004: Invalid response type %s";
    private static final String invalidResponseCode = "WFHTTP000005: Invalid response code %s (full response %s)";
    private static final String failedToWriteException = "WFHTTP000006: Failed to write exception";
    private static final String invalidContentEncoding = "WFHTTP000007: Invalid content encoding %s";
    private static final String authenticationFailed = "WFHTTP000008: Authentication failed";
    private static final String unsupportedQopInDigest = "WFHTTP000009: Unsupported qop version in digest auth";

    public HttpClientMessages_$logger(Logger log) {
        super(log);
    }

    @Override
    public final ConfigXMLParseException portValueOutOfRange(int port) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.portValueOutOfRange$str(), port));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String portValueOutOfRange$str() {
        return portValueOutOfRange;
    }

    @Override
    public final void failedToAcquireSession(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToAcquireSession$str(), new Object[0]);
    }

    protected String failedToAcquireSession$str() {
        return failedToAcquireSession;
    }

    @Override
    public final IOException invalidResponseType(ContentType type) {
        IOException result = new IOException(String.format(this.invalidResponseType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidResponseType$str() {
        return invalidResponseType;
    }

    @Override
    public final IOException invalidResponseCode(int responseCode, ClientResponse response) {
        IOException result = new IOException(String.format(this.invalidResponseCode$str(), responseCode, response));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidResponseCode$str() {
        return invalidResponseCode;
    }

    @Override
    public final void failedToWriteException(Exception ex) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.failedToWriteException$str(), new Object[0]);
    }

    protected String failedToWriteException$str() {
        return failedToWriteException;
    }

    @Override
    public final IOException invalidContentEncoding(String encoding) {
        IOException result = new IOException(String.format(this.invalidContentEncoding$str(), encoding));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidContentEncoding$str() {
        return invalidContentEncoding;
    }

    @Override
    public final SecurityException authenticationFailed() {
        SecurityException result = new SecurityException(String.format(this.authenticationFailed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String authenticationFailed$str() {
        return authenticationFailed;
    }

    @Override
    public final RuntimeException unsupportedQopInDigest() {
        RuntimeException result = new RuntimeException(String.format(this.unsupportedQopInDigest$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedQopInDigest$str() {
        return unsupportedQopInDigest;
    }
}

