/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.repository.ContentFilter;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepositoryElement;
import org.jboss.as.repository.ContentRepositoryImpl;
import org.jboss.as.repository.ExplodedContent;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.repository.TypedInputStream;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;

public interface ContentRepository {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"content-repository"});
    public static final long OBSOLETE_CONTENT_TIMEOUT = System.getSecurityManager() == null ? Long.getLong("org.wildfly.unsupported.content.repository.obsolescence", 300000L).longValue() : AccessController.doPrivileged(() -> Long.getLong("org.wildfly.unsupported.content.repository.obsolescence", 300000L)).longValue();
    public static final long LOCK_TIMEOUT = 5000L;
    public static final String DELETED_CONTENT = "deleted-contents";
    public static final String MARKED_CONTENT = "marked-contents";

    public byte[] addContent(InputStream var1) throws IOException;

    public void addContentReference(ContentReference var1);

    public VirtualFile getContent(byte[] var1);

    public boolean hasContent(byte[] var1);

    public boolean syncContent(ContentReference var1);

    public void removeContent(ContentReference var1);

    default public byte[] explodeContent(byte[] deploymentHash) throws ExplodedContentException {
        return deploymentHash;
    }

    default public byte[] explodeSubContent(byte[] deploymentHash, String relativePath) throws ExplodedContentException {
        throw new UnsupportedOperationException();
    }

    default public void copyExplodedContent(byte[] deploymentHash, Path target) throws ExplodedContentException {
    }

    default public void copyExplodedContentFiles(byte[] deploymentHash, List<String> relativePaths, Path target) throws ExplodedContentException {
    }

    default public byte[] addContentToExploded(byte[] deploymentHash, List<ExplodedContent> addFiles, boolean overwrite) throws ExplodedContentException {
        throw new UnsupportedOperationException();
    }

    default public byte[] removeContentFromExploded(byte[] deploymentHash, List<String> paths) throws ExplodedContentException {
        throw new UnsupportedOperationException();
    }

    default public TypedInputStream readContent(byte[] deploymentHash, String path) throws ExplodedContentException {
        throw new UnsupportedOperationException();
    }

    default public List<ContentRepositoryElement> listContent(byte[] deploymentHash, String path, ContentFilter filter) throws ExplodedContentException {
        return Collections.emptyList();
    }

    public Map<String, Set<String>> cleanObsoleteContent();

    public static class Factory {
        @Deprecated
        private static final String UNSUPPORTED_PROPERTY = "org.wildfly.unsupported.content.repository.obsolescence";

        public static void addService(ServiceTarget serviceTarget, File repoRoot) {
            Factory.addService(serviceTarget, repoRoot, repoRoot);
        }

        public static void addService(ServiceTarget serviceTarget, File repoRoot, File tmpRoot) {
            ContentRepositoryImpl contentRepository = new ContentRepositoryImpl(repoRoot, tmpRoot, OBSOLETE_CONTENT_TIMEOUT, 5000L);
            serviceTarget.addService(SERVICE_NAME, (Service)contentRepository).install();
        }

        public static ContentRepository create(File repoRoot) {
            return Factory.create(repoRoot, repoRoot, OBSOLETE_CONTENT_TIMEOUT);
        }

        public static ContentRepository create(File repoRoot, File tmpRoot) {
            return Factory.create(repoRoot, tmpRoot, OBSOLETE_CONTENT_TIMEOUT);
        }

        static ContentRepository create(File repoRoot, File tmpRoot, long timeout) {
            return new ContentRepositoryImpl(repoRoot, tmpRoot, timeout, 5000L);
        }

        static ContentRepository create(File repoRoot, File tmpRoot, long timeout, long lock) {
            return new ContentRepositoryImpl(repoRoot, tmpRoot, timeout, lock);
        }
    }
}

