/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager;

import java.util.HashMap;
import java.util.Map;

enum Namespace {
    UNKNOWN(null),
    SECURITY_MANAGER_1_0("urn:jboss:domain:security-manager:1.0"),
    SECURITY_MANAGER_3_0("urn:jboss:domain:security-manager:3.0");

    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

