/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.deployment;

import javax.batch.operations.JobOperator;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import org.jberet.spi.ContextClassLoaderJobOperatorContextSelector;
import org.jberet.spi.JobOperatorContext;
import org.jberet.spi.JobXmlResolver;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.batch.BatchServiceNames;
import org.wildfly.extension.batch._private.BatchLogger;
import org.wildfly.extension.batch._private.Capabilities;
import org.wildfly.extension.batch.jberet.BatchConfiguration;
import org.wildfly.extension.batch.jberet.deployment.BatchAttachments;
import org.wildfly.extension.batch.jberet.deployment.BatchEnvironmentService;
import org.wildfly.extension.batch.jberet.deployment.JobOperatorService;
import org.wildfly.extension.batch.jberet.deployment.SecurityAwareBatchEnvironment;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobXmlResolver;
import org.wildfly.extension.batch.job.repository.JobRepositoryFactory;
import org.wildfly.extension.requestcontroller.RequestController;

public class BatchEnvironmentProcessor
implements DeploymentUnitProcessor {
    private final boolean rcPresent;
    private final ContextClassLoaderJobOperatorContextSelector selector;

    public BatchEnvironmentProcessor(boolean rcPresent, ContextClassLoaderJobOperatorContextSelector selector) {
        this.rcPresent = rcPresent;
        this.selector = selector;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(org.jboss.as.server.deployment.Attachments.MODULE)) {
            BatchLogger.LOGGER.tracef("Processing deployment '%s' for the batch environment.", deploymentUnit.getName());
            Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
            ModuleClassLoader moduleClassLoader = module.getClassLoader();
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
            WildFlyJobXmlResolver jobXmlResolver = WildFlyJobXmlResolver.forDeployment((DeploymentUnit)deploymentUnit);
            BatchEnvironmentService service = new BatchEnvironmentService((ClassLoader)moduleClassLoader, (JobXmlResolver)jobXmlResolver, deploymentUnit.getName());
            service.getJobRepositoryInjector().setValue((Value)new ImmediateValue((Object)JobRepositoryFactory.getInstance().getJobRepository(moduleDescription)));
            ServiceBuilder serviceBuilder = serviceTarget.addService(BatchServiceNames.batchEnvironmentServiceName(deploymentUnit), (Service)service);
            serviceBuilder.addDependency(support.getCapabilityServiceName(Capabilities.BATCH_CONFIGURATION_CAPABILITY.getName()), BatchConfiguration.class, (Injector)service.getBatchConfigurationInjector());
            serviceBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, (Injector)service.getTransactionManagerInjector());
            if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
                BatchLogger.LOGGER.tracef("Adding BeanManager service dependency for deployment %s", deploymentUnit.getName());
                serviceBuilder.addDependency(BatchServiceNames.beanManagerServiceName(deploymentUnit), BeanManager.class, (Injector)service.getBeanManagerInjector());
            }
            if (this.rcPresent) {
                serviceBuilder.addDependency(RequestController.SERVICE_NAME, RequestController.class, (Injector)service.getRequestControllerInjector());
            }
            serviceBuilder.install();
            JobOperatorService jobOperatorService = new JobOperatorService(Boolean.FALSE, deploymentUnit.getName(), jobXmlResolver);
            Services.addServerExecutorDependency((ServiceBuilder)serviceTarget.addService(org.wildfly.extension.batch.jberet.BatchServiceNames.jobOperatorServiceName((DeploymentUnit)deploymentUnit), (Service)jobOperatorService).addDependency(support.getCapabilityServiceName(Capabilities.BATCH_CONFIGURATION_CAPABILITY.getName()), BatchConfiguration.class, (Injector)jobOperatorService.getBatchConfigurationInjector()).addDependency(SuspendController.SERVICE_NAME, SuspendController.class, (Injector)jobOperatorService.getSuspendControllerInjector()).addDependency(org.wildfly.extension.batch.jberet.BatchServiceNames.batchEnvironmentServiceName((DeploymentUnit)deploymentUnit), SecurityAwareBatchEnvironment.class, jobOperatorService.getBatchEnvironmentInjector()), (Injector)jobOperatorService.getExecutorServiceInjector()).install();
            deploymentUnit.putAttachment(BatchAttachments.JOB_OPERATOR, (Object)jobOperatorService);
            this.selector.registerContext((ClassLoader)moduleClassLoader, JobOperatorContext.create((JobOperator)jobOperatorService));
        }
    }

    public void undeploy(DeploymentUnit context) {
        if (context.hasAttachment(org.jboss.as.server.deployment.Attachments.MODULE)) {
            this.selector.unregisterContext((ClassLoader)((Module)context.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE)).getClassLoader());
        }
    }
}

