/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.digest.DigestQuote;
import org.wildfly.security.sasl.digest.AbstractDigestMechanism;
import org.wildfly.security.sasl.digest._private.DigestUtil;
import org.wildfly.security.util.ByteStringBuilder;

class DigestSaslServer
extends AbstractDigestMechanism
implements SaslServer {
    private final Predicate<String> digestUriAccepted;
    private static final byte STEP_ONE = 1;
    private static final byte STEP_THREE = 3;
    private String[] realms;
    private String supportedCiphers;
    private int receivingMaxBuffSize = 65536;
    private String[] qops;
    private int nonceCount = -1;
    private String receivedClientUri;

    DigestSaslServer(String[] realms, String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, Charset charset, String[] qops, String[] ciphers, Predicate<String> digestUriAccepted, Supplier<Provider[]> providers) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler, AbstractDigestMechanism.FORMAT.SERVER, charset, ciphers, providers);
        this.realms = realms;
        this.supportedCiphers = DigestSaslServer.getSupportedCiphers(ciphers);
        this.qops = qops;
        this.digestUriAccepted = digestUriAccepted;
    }

    private byte[] generateChallenge() {
        ByteStringBuilder challenge = new ByteStringBuilder();
        StringBuilder sb = new StringBuilder();
        for (String realm : this.realms) {
            sb.append("realm=\"").append(DigestQuote.quote(realm)).append("\"").append(',');
        }
        challenge.append(sb.toString().getBytes(this.getCharset()));
        assert (this.nonce == null);
        this.nonce = DigestSaslServer.generateNonce();
        challenge.append("nonce=\"");
        challenge.append(DigestQuote.quote(this.nonce));
        challenge.append("\"").append(',');
        if (this.qops != null) {
            challenge.append("qop=\"");
            boolean first = true;
            for (String qop : this.qops) {
                if (!first) {
                    challenge.append(',');
                }
                first = false;
                challenge.append(DigestQuote.quote(qop));
            }
            challenge.append("\"").append(',');
        }
        if (this.receivingMaxBuffSize != 65536) {
            challenge.append("maxbuf=");
            challenge.append(String.valueOf(this.receivingMaxBuffSize));
            challenge.append(',');
        }
        if (StandardCharsets.UTF_8.equals(this.getCharset())) {
            challenge.append("charset=");
            challenge.append("utf-8");
            challenge.append(',');
        }
        if (this.supportedCiphers != null && this.qops != null && this.arrayContains(this.qops, "auth-conf")) {
            challenge.append("cipher=\"");
            challenge.append(this.supportedCiphers);
            challenge.append("\"").append(',');
        }
        challenge.append("algorithm=md5-sess");
        return challenge.toArray();
    }

    private void noteDigestResponseData(HashMap<String, byte[]> parsedDigestResponse) {
        byte[] data = parsedDigestResponse.get("nc");
        this.nonceCount = data != null ? Integer.parseInt(new String(data, StandardCharsets.UTF_8)) : -1;
        data = parsedDigestResponse.get("cipher");
        this.cipher = data != null ? new String(data, StandardCharsets.UTF_8) : "";
        data = parsedDigestResponse.get("authzid");
        this.authzid = data != null ? new String(data, StandardCharsets.UTF_8) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] validateDigestResponse(HashMap<String, byte[]> parsedDigestResponse) throws SaslException {
        NameCallback nameCallback;
        RealmCallback realmCallback;
        byte[] digest_urp;
        if (this.nonceCount != 1) {
            throw ElytronMessages.log.mechNonceCountMustEqual(this.getMechanismName(), 1, this.nonceCount).toSaslException();
        }
        Charset clientCharset = StandardCharsets.ISO_8859_1;
        if (parsedDigestResponse.get("charset") != null) {
            String cCharset = new String(parsedDigestResponse.get("charset"), StandardCharsets.UTF_8);
            if (!cCharset.equals("utf-8")) throw ElytronMessages.log.mechUnknownCharset(this.getMechanismName()).toSaslException();
            if (!StandardCharsets.UTF_8.equals(this.getCharset())) throw ElytronMessages.log.mechUnsupportedCharset(this.getMechanismName(), "UTF-8").toSaslException();
            clientCharset = StandardCharsets.UTF_8;
        }
        if (parsedDigestResponse.get("username") == null) {
            throw ElytronMessages.log.mechMissingDirective(this.getMechanismName(), "username").toSaslException();
        }
        String userName = new String(parsedDigestResponse.get("username"), clientCharset);
        String clientRealm = parsedDigestResponse.get("realm") != null ? new String(parsedDigestResponse.get("realm"), clientCharset) : "";
        if (!this.arrayContains(this.realms, clientRealm)) {
            throw ElytronMessages.log.mechDisallowedClientRealm(this.getMechanismName(), clientRealm).toSaslException();
        }
        if (parsedDigestResponse.get("nonce") == null) {
            throw ElytronMessages.log.mechMissingDirective(this.getMechanismName(), "nonce").toSaslException();
        }
        byte[] nonceFromClient = parsedDigestResponse.get("nonce");
        if (!Arrays.equals(this.nonce, nonceFromClient)) {
            throw ElytronMessages.log.mechNoncesDoNotMatch(this.getMechanismName()).toSaslException();
        }
        if (parsedDigestResponse.get("cnonce") == null) {
            throw ElytronMessages.log.mechMissingDirective(this.getMechanismName(), "cnonce").toSaslException();
        }
        this.cnonce = parsedDigestResponse.get("cnonce");
        if (parsedDigestResponse.get("nc") == null) {
            throw ElytronMessages.log.mechMissingDirective(this.getMechanismName(), "nc").toSaslException();
        }
        if (parsedDigestResponse.get("digest-uri") == null) throw ElytronMessages.log.mechMissingDirective(this.getMechanismName(), "digest-uri").toSaslException();
        this.receivedClientUri = new String(parsedDigestResponse.get("digest-uri"), clientCharset);
        if (!this.digestUriAccepted.test(this.receivedClientUri.toLowerCase(Locale.ROOT))) {
            throw ElytronMessages.log.mechMismatchedWrongDigestUri(this.getMechanismName(), this.receivedClientUri).toSaslException();
        }
        this.qop = "auth";
        if (parsedDigestResponse.get("qop") != null) {
            this.qop = new String(parsedDigestResponse.get("qop"), clientCharset);
            if (!this.arrayContains(DigestUtil.QOP_VALUES, this.qop)) {
                throw ElytronMessages.log.mechUnexpectedQop(this.getMechanismName(), this.qop).toSaslException();
            }
            if (this.qop != null && !this.qop.equals("auth")) {
                this.setWrapper(new AbstractDigestMechanism.DigestWrapper(this.qop.equals("auth-conf")));
            }
        }
        if ((digest_urp = this.getPredigestedSaltedPassword(realmCallback = new RealmCallback("User realm", clientRealm), nameCallback = new NameCallback("User name", userName))) == null) {
            digest_urp = this.getSaltedPasswordFromTwoWay(realmCallback, nameCallback, true);
        }
        if (digest_urp == null) {
            digest_urp = this.getSaltedPasswordFromPasswordCallback(realmCallback, nameCallback, true);
        }
        if (digest_urp == null) {
            throw ElytronMessages.log.mechCallbackHandlerDoesNotSupportCredentialAcquisition(this.getMechanismName(), null).toSaslException();
        }
        this.hA1 = DigestUtil.H_A1(this.messageDigest, digest_urp, this.nonce, this.cnonce, this.authzid, clientCharset);
        byte[] expectedResponse = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.nonceCount, this.cnonce, this.authzid, this.qop, this.receivedClientUri, true);
        if (parsedDigestResponse.get("response") == null) {
            throw ElytronMessages.log.mechMissingDirective(this.getMechanismName(), "response").toSaslException();
        }
        if (!Arrays.equals(expectedResponse, parsedDigestResponse.get("response"))) {
            throw ElytronMessages.log.mechAuthenticationRejectedInvalidProof(this.getMechanismName()).toSaslException();
        }
        this.createCiphersAndKeys();
        String authorizationId = this.authzid == null || this.authzid.isEmpty() ? userName : this.authzid;
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(userName, authorizationId);
        try {
            this.tryHandleCallbacks(authorizeCallback);
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.log.mechAuthorizationUnsupported(this.getMechanismName(), e).toSaslException();
        }
        if (!authorizeCallback.isAuthorized()) {
            throw ElytronMessages.log.mechAuthorizationFailed(this.getMechanismName(), userName, authorizationId).toSaslException();
        }
        this.authzid = authorizeCallback.getAuthorizedID();
        return this.createResponseAuth(parsedDigestResponse);
    }

    private byte[] createResponseAuth(HashMap<String, byte[]> parsedDigestResponse) {
        ByteStringBuilder responseAuth = new ByteStringBuilder();
        responseAuth.append("rspauth=");
        byte[] response_value = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.nonceCount, this.cnonce, this.authzid, this.qop, this.receivedClientUri != null ? this.receivedClientUri : this.digestURI, false);
        responseAuth.append(response_value);
        return responseAuth.toArray();
    }

    @Override
    public String getAuthorizationID() {
        return this.authzid;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this.evaluateMessage(response);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        switch (state) {
            case 1: {
                if (message != null && message.length != 0) {
                    throw ElytronMessages.log.mechInitialChallengeMustBeEmpty(this.getMechanismName()).toSaslException();
                }
                this.setNegotiationState(3);
                return this.generateChallenge();
            }
            case 3: {
                HashMap<String, byte[]> parsedDigestResponse;
                if (message == null || message.length == 0) {
                    throw ElytronMessages.log.mechClientRefusesToInitiateAuthentication(this.getMechanismName()).toSaslException();
                }
                try {
                    parsedDigestResponse = org.wildfly.security.mechanism.digest.DigestUtil.parseResponse(message, this.charset, false, this.getMechanismName());
                }
                catch (AuthenticationMechanismException e) {
                    throw e.toSaslException();
                }
                this.noteDigestResponseData(parsedDigestResponse);
                byte[] response = this.validateDigestResponse(parsedDigestResponse);
                this.negotiationComplete();
                return response;
            }
        }
        throw Assert.impossibleSwitchCase(state);
    }
}

