/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.elytron;

import java.security.Principal;
import java.security.acl.Group;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class SecurityDomainContextRealm
implements SecurityRealm {
    private SecurityDomainContext domainContext;

    public SecurityDomainContextRealm(SecurityDomainContext context) {
        this.domainContext = context;
    }

    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        return new PicketBoxBasedIdentity(principal);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        if (PasswordGuessEvidence.class.isAssignableFrom(evidenceType)) {
            return SupportLevel.SUPPORTED;
        }
        return SupportLevel.UNSUPPORTED;
    }

    private class PicketBoxBasedIdentity
    implements RealmIdentity {
        private final Principal principal;
        private Subject jaasSubject;

        private PicketBoxBasedIdentity(Principal principal) {
            this.principal = principal;
        }

        public Principal getRealmIdentityPrincipal() {
            return this.principal;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SecurityDomainContextRealm.this.getCredentialAcquireSupport(credentialType, algorithmName);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SecurityDomainContextRealm.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SecurityDomainContextRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            if (SecurityDomainContextRealm.this.domainContext == null || SecurityDomainContextRealm.this.domainContext.getAuthenticationManager() == null) {
                throw new RealmUnavailableException();
            }
            this.jaasSubject = new Subject();
            Object jaasCredential = evidence;
            if (evidence instanceof PasswordGuessEvidence) {
                jaasCredential = ((PasswordGuessEvidence)evidence).getGuess();
            }
            return SecurityDomainContextRealm.this.domainContext.getAuthenticationManager().isValid(this.principal, jaasCredential, this.jaasSubject);
        }

        public boolean exists() throws RealmUnavailableException {
            return true;
        }

        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            Set<Principal> principals;
            Attributes attributes = null;
            if (this.jaasSubject != null && (principals = this.jaasSubject.getPrincipals()) != null) {
                for (Principal principal : principals) {
                    if (!(principal instanceof Group)) continue;
                    String key = principal.getName();
                    HashSet<String> values = new HashSet<String>();
                    Enumeration enumeration = ((Group)principal).members();
                    while (enumeration.hasMoreElements()) {
                        values.add(((Principal)enumeration.nextElement()).getName());
                    }
                    if (attributes == null) {
                        attributes = new MapAttributes();
                    }
                    attributes.addAll(key, values);
                }
            }
            if (attributes == null) {
                attributes = Attributes.EMPTY;
            }
            return AuthorizationIdentity.basicIdentity((Attributes)attributes);
        }
    }
}

