/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.logging;

import java.lang.reflect.Method;
import javax.naming.InvalidNameException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.login.LoginException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.StartException;
import org.jboss.security.vault.SecurityVaultException;

@MessageLogger(projectCode="WFLYSEC", length=4)
public interface SecurityLogger
extends BasicLogger {
    public static final SecurityLogger ROOT_LOGGER = (SecurityLogger)Logger.getMessageLogger(SecurityLogger.class, (String)"org.jboss.as.security");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Current PicketBox version=%s")
    public void currentVersion(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Activating Security Subsystem")
    public void activatingSecuritySubsystem();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Error deleting JACC Policy")
    public void errorDeletingJACCPolicy(@Cause Throwable var1);

    @Message(id=4, value="Unable to get the Module Class Loader")
    public IllegalStateException unableToGetModuleClassLoader(@Cause Throwable var1);

    @Message(id=5, value="Operation not supported : %s")
    public OperationNotSupportedException operationNotSupported(Method var1);

    @Message(id=6, value="Missing module name for the %s")
    public IllegalArgumentException missingModuleName(String var1);

    @Message(id=7, value="Runtime Exception:")
    public RuntimeException runtimeException(@Cause Throwable var1);

    @Message(id=8, value="Module Load Exception:")
    public ModuleLoadException moduleLoadException(@Cause Throwable var1);

    @Message(id=9, value="Name cannot be null or empty")
    public InvalidNameException nullName();

    @Message(id=10, value="Remoting connection found but no UserPrincipal.")
    public LoginException remotingConnectionWithNoUserPrincipal();

    @Message(id=11, value="Argument %s is null")
    public IllegalArgumentException nullArgument(String var1);

    @Message(id=12, value="Unable to start the %s service")
    public StartException unableToStartException(String var1, @Cause Throwable var2);

    @Message(id=13, value="Class not found : %s")
    public ClassNotFoundException cnfe(String var1);

    @Message(id=14, value="Class not found : %s")
    public ClassNotFoundException cnfeThrow(String var1, @Cause Throwable var2);

    @Message(id=15, value="Security Exception")
    public SecurityException securityException(@Cause Throwable var1);

    @Message(id=16, value="Security Exception: %s")
    public SecurityException securityException(String var1);

    @Message(id=17, value="Vault Reader Exception:")
    public VaultReaderException vaultReaderException(@Cause Throwable var1);

    @Message(id=18, value="Use the ResourceDescriptionResolver variant")
    public UnsupportedOperationException unsupportedOperationExceptionUseResourceDesc();

    @Message(id=19, value="Unsupported Operation")
    public UnsupportedOperationException unsupportedOperation();

    @Message(id=20, value="Illegal Argument:%s")
    public IllegalArgumentException illegalArgument(String var1);

    @Message(id=21, value="Illegal Argument:%s")
    public XMLStreamException xmlStreamException(String var1, @Param Location var2);

    @Message(id=22, value="A security domain can have either an <authentication> or <authentication-jaspi> element, not both")
    public XMLStreamException xmlStreamExceptionAuth(@Param Location var1);

    @Message(id=23, value="Missing required attribute: either %s or %s must be present")
    public XMLStreamException xmlStreamExceptionMissingAttribute(String var1, String var2, @Param Location var3);

    @Message(id=24, value="auth-module references a login module stack that doesn't exist::%s")
    public IllegalArgumentException loginModuleStackIllegalArgument(String var1);

    @Message(id=25, value="Address did not contain a security domain name")
    public IllegalArgumentException addressDidNotContainSecurityDomain();

    @Message(id=26, value="Vault is not initialized")
    public SecurityException vaultNotInitializedException();

    @Message(id=27, value="Invalid User")
    public SecurityException invalidUserException();

    @Message(id=28, value="Security Management not injected")
    public SecurityException securityManagementNotInjected();

    @Message(id=29, value="Security realm '%s' not found.")
    public SecurityException realmNotFound(String var1);

    @Message(id=31, value="Failure calling CallbackHandler '%s'")
    public LoginException failureCallingSecurityRealm(String var1);

    @Message(id=32, value="No authentication cache for security domain '%s' available")
    public OperationFailedException noAuthenticationCacheAvailable(String var1);

    @Message(id=33, value="No UserPrincipalFound constructing RemotingConnectionPrincipal.")
    public IllegalStateException noUserPrincipalFound();

    @Message(id=34, value="Interrupted waiting for security domain '%s'")
    public OperationFailedException interruptedWaitingForSecurityDomain(String var1);

    @Message(id=35, value="Required security domain is not available '%s'")
    public OperationFailedException requiredSecurityDomainServiceNotAvailable(String var1);

    @Message(id=36, value="At least one attribute is to be defined")
    public OperationFailedException requiredJSSEConfigurationAttribute();

    @Message(id=37, value="Keystore '%s' doesn't exist.\nkeystore could be created: keytool -genseckey -alias Vault -storetype jceks -keyalg AES -keysize 128 -storepass secretsecret -keypass secretsecret -keystore %s")
    public Exception keyStoreDoesnotExistWithExample(String var1, String var2);

    @Message(id=38, value="Keystore [%s] is not writable or not a file.")
    public Exception keyStoreNotWritable(String var1);

    @Message(id=39, value="Keystore password has to be specified.")
    public Exception keyStorePasswordNotSpecified();

    @Message(id=40, value="Encryption directory has to be specified.")
    public Exception encryptionDirectoryHasToBeSpecified();

    @Message(id=41, value="Encryption directory is not a directory or doesn't exist. (%s)")
    public Exception encryptionDirectoryDoesNotExist(String var1);

    @Message(id=42, value="Cannot create encryption directory %s")
    public Exception cannotCreateEncryptionDirectory(String var1);

    @Message(id=43, value="Iteration count has to be within 1 - 2147483647, but it is %s.")
    public Exception iterationCountOutOfRange(String var1);

    @Message(id=44, value="Salt has to be exactly 8 characters long.")
    public Exception saltWrongLength();

    @Message(id=45, value="Exception encountered:")
    public Exception securityVaultException(@Cause SecurityVaultException var1);

    @Message(id=46, value="Vault alias has to be specified.")
    public Exception vaultAliasNotSpecified();

    @Message(id=47, value="Secured attribute value has been stored in Vault.\nPlease make note of the following:\n********************************************\nVault Block:%s\nAttribute Name:%s\nConfiguration should be done as follows:\n%s\n********************************************")
    public String vaultAttributeCreateDisplay(String var1, String var2, String var3);

    @Message(id=48, value="Vault Configuration in WildFly configuration file:")
    public String vaultConfigurationTitle();

    @Message(id=49, value="No console.")
    public String noConsole();

    @Message(id=0, value="Enter directory to store encrypted files:")
    public String enterEncryptionDirectory();

    @Message(id=0, value="Enter Keystore URL:")
    public String enterKeyStoreURL();

    @Message(id=0, value="Enter Keystore password:")
    public String enterKeyStorePassword();

    @Message(id=0, value="Enter 8 character salt:")
    public String enterSalt();

    @Message(id=0, value="Enter iteration count as a number (e.g.: 44):")
    public String enterIterationCount();

    @Message(id=0, value="Enter Keystore Alias:")
    public String enterKeyStoreAlias();

    @Message(id=56, value="Initializing Vault")
    public String initializingVault();

    @Message(id=57, value="Vault is initialized and ready for use")
    public String vaultInitialized();

    @Message(id=58, value="Handshake with Vault complete")
    public String handshakeComplete();

    @Message(id=59, value="Exception encountered:")
    public String exceptionEncountered();

    @Message(id=0, value="Enter your password:")
    public String enterYourPassword();

    @Deprecated
    @Message(id=61, value=" again: ")
    public String passwordAgain();

    @Message(id=0, value="Values entered don't match")
    public String passwordsDoNotMatch();

    @Message(id=0, value="Values match")
    public String passwordsMatch();

    @Message(id=0, value="Problem occurred:")
    public String problemOcurred();

    @Message(id=0, value="Please enter a Digit::   0: Start Interactive Session   1: Remove Interactive Session  2: Exit")
    public String interactiveCommandString();

    @Message(id=0, value="Starting an interactive session")
    public String startingInteractiveSession();

    @Message(id=0, value="Removing the current interactive session")
    public String removingInteractiveSession();

    @Message(id=68, value="Problem while parsing command line parameters:")
    public String problemParsingCommandLineParameters();

    @Message(id=0, value="Keystore URL")
    public String cmdLineKeyStoreURL();

    @Message(id=0, value="Keystore password")
    public String cmdLineKeyStorePassword();

    @Message(id=0, value="Directory containing encrypted files")
    public String cmdLineEncryptionDirectory();

    @Message(id=0, value="8 character salt")
    public String cmdLineSalt();

    @Message(id=0, value="Iteration count")
    public String cmdLineIterationCount();

    @Message(id=0, value="Vault keystore alias")
    public String cmdLineVaultKeyStoreAlias();

    @Message(id=0, value="Vault block")
    public String cmdLineVaultBlock();

    @Message(id=0, value="Attribute name")
    public String cmdLineAttributeName();

    @Message(id=0, value="Secured attribute value (such as password) to store")
    public String cmdLineSecuredAttribute();

    @Message(id=0, value="Check whether the secured attribute already exists in the Vault")
    public String cmdLineCheckAttribute();

    @Message(id=0, value="Help")
    public String cmdLineHelp();

    @Message(id=80, value="Secured attribute (password) already exists.")
    public String cmdLineSecuredAttributeAlreadyExists();

    @Message(id=81, value="Secured attribute (password) doesn't exist.")
    public String cmdLineSecuredAttributeDoesNotExist();

    @Message(id=0, value="Enter your password again:")
    public String enterYourPasswordAgain();

    @Message(id=0, value="Enter Keystore password again:")
    public String enterKeyStorePasswordAgain();

    @Message(id=84, value="'%s' parameter type or length is incorrect")
    public IllegalArgumentException incorrectKeystoreParameters(String var1);

    @Message(id=0, value="Remove secured attribute from the Vault")
    public String cmdLineRemoveSecuredAttribute();

    @Message(id=0, value="Automatically create keystore when it doesn't exist")
    public String cmdLineAutomaticallyCreateKeystore();

    @Message(id=0, value="Secured attribute %s has been successfuly removed from vault")
    public String messageAttributeRemovedSuccessfuly(String var1);

    @Message(id=0, value="Secured attribute %s was not removed from vault, check whether it exist")
    public String messageAttributeNotRemoved(String var1);

    @Message(id=0, value="Please enter a Digit::  0: Store a secured attribute  1: Check whether a secured attribute exists  2: Remove secured attribute  3: Exit")
    public String interactionCommandOptions();

    @Message(id=0, value="Task: Store a secured attribute")
    public String taskStoreSecuredAttribute();

    @Message(id=0, value="Please enter secured attribute value (such as password)")
    public String interactivePromptSecureAttributeValue();

    @Message(id=0, value="Please enter secured attribute value again")
    public String interactivePromptSecureAttributeValueAgain();

    @Message(id=0, value="Enter Vault Block:")
    public String interactivePromptVaultBlock();

    @Message(id=0, value="Enter Attribute Name:")
    public String interactivePromptAttributeName();

    @Message(id=0, value="Task: Verify whether a secured attribute exists")
    public String taskVerifySecuredAttributeExists();

    @Message(id=0, value="No value has been stored for %s")
    public String interactiveMessageNoValueStored(String var1);

    @Message(id=0, value="A value exists for %s")
    public String interactiveMessageValueStored(String var1);

    @Message(id=0, value="Task: Remove secured attribute")
    public String taskRemoveSecuredAttribute();

    @Message(id=0, value="Action not specified")
    public String actionNotSpecified();

    @Message(id=100, value="Legacy security domain %s doesn't contain a valid JSSE configuration")
    public StartException unableToLocateJSSEConfig(String var1);

    @Message(id=101, value="Unable to find a %s configuration in JSSE security domain %s")
    public StartException unableToLocateComponentInJSSEDomain(String var1, String var2);

    @Message(id=102, value="Could not find a %s of type %s in the JSSE security domain %s")
    public StartException expectedManagerTypeNotFound(String var1, String var2, String var3);
}

