/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.cond.Evaluatable;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;

public abstract class AttributeValue
implements Evaluatable {
    private URI type;

    protected AttributeValue(URI type) {
        this.type = type;
    }

    @Override
    public URI getType() {
        return this.type;
    }

    public abstract Object getValue();

    @Override
    public final boolean returnsBag() {
        return this.isBag();
    }

    @Override
    public final boolean evaluatesToBag() {
        return this.isBag();
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public boolean isBag() {
        return false;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        return new EvaluationResult(this);
    }

    public abstract String encode();

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        out.println(indenter.makeString() + this.encodeWithTags(true));
    }

    public String encodeWithTags(boolean includeType) {
        if (includeType) {
            return "<AttributeValue DataType=\"" + this.type.toString() + "\">" + this.encode() + "</AttributeValue>";
        }
        return "<AttributeValue>" + this.encode() + "</AttributeValue>";
    }
}

