/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.w3c.dom.Node;

public class IntegerAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#integer";
    private static URI identifierURI = URI.create("http://www.w3.org/2001/XMLSchema#integer");
    private long value;

    public IntegerAttribute(long value) {
        super(identifierURI);
        this.value = value;
    }

    public static IntegerAttribute getInstance(Node root) throws NumberFormatException {
        return IntegerAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static IntegerAttribute getInstance(String value) throws NumberFormatException {
        if (value.length() >= 1 && value.charAt(0) == '+') {
            value = value.substring(1);
        }
        return new IntegerAttribute(Long.parseLong(value));
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntegerAttribute)) {
            return false;
        }
        IntegerAttribute other = (IntegerAttribute)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public String encode() {
        return String.valueOf(this.value);
    }
}

