/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.cond.Evaluatable;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.Expression;
import org.jboss.security.xacml.sunxacml.cond.ExpressionHandler;
import org.jboss.security.xacml.sunxacml.cond.Function;
import org.jboss.security.xacml.sunxacml.cond.FunctionFactory;
import org.jboss.security.xacml.sunxacml.cond.VariableManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Apply
implements Evaluatable {
    private Function function;
    private List xprs;
    protected static final Logger logger = Logger.getLogger(Apply.class.getName());

    public Apply(Function function, List xprs) throws IllegalArgumentException {
        function.checkInputs(xprs);
        this.function = function;
        this.xprs = Collections.unmodifiableList(new ArrayList(xprs));
    }

    public Apply(Function function, List xprs, boolean isCondition) throws IllegalArgumentException {
        if (isCondition) {
            throw new IllegalArgumentException("As of version 2.0 an Apply may not represent a Condition");
        }
        function.checkInputs(xprs);
        this.function = function;
        this.xprs = Collections.unmodifiableList(new ArrayList(xprs));
    }

    public static Apply getConditionInstance(Node root, String xpathVersion, VariableManager manager) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getConditionInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), manager);
    }

    public static Apply getConditionInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getConditionInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    public static Apply getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getGeneralInstance(), metaData, manager);
    }

    public static Apply getInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getGeneralInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    private static Apply getInstance(Node root, FunctionFactory factory, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        Function function = ExpressionHandler.getFunction(root, metaData, factory);
        ArrayList<Expression> xprs = new ArrayList<Expression>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Expression xpr = ExpressionHandler.parseExpression(nodes.item(i), metaData, manager);
            if (xpr == null) continue;
            xprs.add(xpr);
        }
        return new Apply(function, xprs);
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public List getChildren() {
        return this.xprs;
    }

    public boolean isCondition() {
        return false;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        EvaluationResult result = this.function.evaluate(this.xprs, context);
        AttributeValue avalue = result.getAttributeValue();
        StringBuilder builder = new StringBuilder();
        builder.append("Function:" + this.function.getIdentifier().toASCIIString());
        for (Object obj : this.xprs) {
            builder.append(":").append(obj).append(":");
        }
        builder.append("::result=");
        if (avalue != null && !avalue.isBag()) {
            builder.append(avalue.encode());
        }
        logger.log(Level.FINE, builder.toString());
        return result;
    }

    @Override
    public URI getType() {
        return this.function.getReturnType();
    }

    @Override
    public boolean returnsBag() {
        return this.function.returnsBag();
    }

    @Override
    public boolean evaluatesToBag() {
        return this.function.returnsBag();
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Apply FunctionId=\"" + this.function.getIdentifier() + "\">");
        indenter.in();
        for (Expression xpr : this.xprs) {
            xpr.encode(output, indenter);
        }
        indenter.out();
        out.println(indent + "</Apply>");
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toString();
    }
}

