/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.affinity.impl.KeyAffinityServiceImpl;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.SuppliedValueService;

public class KeyAffinityServiceFactoryBuilder
extends CapabilityServiceNameProvider
implements Builder<KeyAffinityServiceFactory> {
    private volatile int bufferSize = 100;

    public KeyAffinityServiceFactoryBuilder(PathAddress address) {
        super((Capability)CacheContainerResourceDefinition.Capability.KEY_AFFINITY_FACTORY, address);
    }

    public KeyAffinityServiceFactoryBuilder setBufferSize(int size) {
        this.bufferSize = size;
        return this;
    }

    public ServiceBuilder<KeyAffinityServiceFactory> build(ServiceTarget target) {
        int bufferSize = this.bufferSize;
        Function<ExecutorService, KeyAffinityServiceFactory> mapper = executor -> new KeyAffinityServiceFactory((ExecutorService)executor, bufferSize){
            final /* synthetic */ ExecutorService val$executor;
            final /* synthetic */ int val$bufferSize;
            {
                this.val$executor = executorService;
                this.val$bufferSize = n;
            }

            public <K> KeyAffinityService<K> createService(Cache<K, ?> cache, KeyGenerator<K> generator) {
                CacheMode mode = cache.getCacheConfiguration().clustering().cacheMode();
                return mode.isDistributed() || mode.isReplicated() ? new KeyAffinityServiceImpl((Executor)this.val$executor, cache, generator, this.val$bufferSize, Collections.singleton(cache.getCacheManager().getAddress()), false) : new SimpleKeyAffinityService<K>(generator);
            }
        };
        Supplier<ExecutorService> supplier = () -> {
            ThreadGroup threadGroup = new ThreadGroup("KeyAffinityService ThreadGroup");
            String namePattern = "KeyAffinityService Thread Pool -- %t";
            PrivilegedAction<ThreadFactory> action = () -> new JBossThreadFactory(threadGroup, Boolean.FALSE, null, namePattern, null, null);
            return Executors.newCachedThreadPool(AccessController.doPrivileged(action));
        };
        SuppliedValueService service = new SuppliedValueService(mapper, supplier, ExecutorService::shutdown);
        return new AsynchronousServiceBuilder(this.getServiceName(), (Service)service).startSynchronously().build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    private static class SimpleKeyAffinityService<K>
    implements KeyAffinityService<K> {
        private final KeyGenerator<K> generator;
        private volatile boolean started = false;

        SimpleKeyAffinityService(KeyGenerator<K> generator) {
            this.generator = generator;
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.started = false;
        }

        public K getKeyForAddress(Address address) {
            return (K)this.generator.getKey();
        }

        public K getCollocatedKey(K otherKey) {
            return (K)this.generator.getKey();
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

