/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.stream.Stream;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreBuilder;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class MixedKeyedJDBCStoreBuilder
extends JDBCStoreBuilder<JdbcMixedStoreConfiguration, JdbcMixedStoreConfigurationBuilder> {
    private final ValueDependency<TableManipulationConfiguration> binaryTable;
    private final ValueDependency<TableManipulationConfiguration> stringTable;

    MixedKeyedJDBCStoreBuilder(PathAddress address) {
        super(address, JdbcMixedStoreConfigurationBuilder.class);
        PathAddress cacheAddress = address.getParent();
        this.binaryTable = new InjectedValueDependency(CacheComponent.BINARY_TABLE.getServiceName(cacheAddress), TableManipulationConfiguration.class);
        this.stringTable = new InjectedValueDependency(CacheComponent.STRING_TABLE.getServiceName(cacheAddress), TableManipulationConfiguration.class);
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        ServiceBuilder<PersistenceConfiguration> builder = super.build(target);
        Stream.of(this.binaryTable, this.stringTable).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public void accept(JdbcMixedStoreConfigurationBuilder builder) {
        builder.binaryTable().read((TableManipulationConfiguration)this.binaryTable.getValue());
        builder.stringTable().read((TableManipulationConfiguration)this.stringTable.getValue());
        super.accept(builder);
    }
}

