/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreBuilder;
import org.jboss.as.controller.PathAddress;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class StringKeyedJDBCStoreBuilder
extends JDBCStoreBuilder<JdbcStringBasedStoreConfiguration, JdbcStringBasedStoreConfigurationBuilder> {
    private final ValueDependency<TableManipulationConfiguration> table;
    private final ValueDependency<Module> module;

    StringKeyedJDBCStoreBuilder(PathAddress address) {
        super(address, JdbcStringBasedStoreConfigurationBuilder.class);
        PathAddress cacheAddress = address.getParent();
        PathAddress containerAddress = cacheAddress.getParent();
        this.table = new InjectedValueDependency(CacheComponent.STRING_TABLE.getServiceName(cacheAddress), TableManipulationConfiguration.class);
        this.module = new InjectedValueDependency(CacheContainerComponent.MODULE.getServiceName(containerAddress), Module.class);
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        ServiceBuilder<PersistenceConfiguration> builder = super.build(target);
        Stream.of(this.table, this.module).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public void accept(JdbcStringBasedStoreConfigurationBuilder builder) {
        builder.table().read((TableManipulationConfiguration)this.table.getValue());
        StreamSupport.stream(ServiceLoader.load(TwoWayKey2StringMapper.class, (ClassLoader)((Module)this.module.getValue()).getClassLoader()).spliterator(), false).findFirst().ifPresent(impl -> builder.key2StringMapper(impl.getClass()));
        super.accept(builder);
    }
}

