/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.impl.LastValueQueue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public class QueueFactoryImpl
implements QueueFactory {
    protected final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    protected final ScheduledExecutorService scheduledExecutor;
    protected PostOffice postOffice;
    protected final StorageManager storageManager;
    protected final ExecutorFactory executorFactory;

    public QueueFactoryImpl(ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutor, HierarchicalRepository<AddressSettings> addressSettingsRepository, StorageManager storageManager) {
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.storageManager = storageManager;
        this.executorFactory = executorFactory;
    }

    @Override
    public void setPostOffice(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    @Override
    public Queue createQueueWith(QueueConfig config) {
        AddressSettings addressSettings = this.addressSettingsRepository.getMatch(config.address().toString());
        QueueImpl queue = addressSettings.isLastValueQueue() ? new LastValueQueue(config.id(), config.address(), config.name(), config.filter(), config.pageSubscription(), config.user(), config.isDurable(), config.isTemporary(), config.isAutoCreated(), this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor()) : new QueueImpl(config.id(), config.address(), config.name(), config.filter(), config.pageSubscription(), config.user(), config.isDurable(), config.isTemporary(), config.isAutoCreated(), this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor());
        return queue;
    }

    @Override
    @Deprecated
    public Queue createQueue(long persistenceID, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated) {
        AddressSettings addressSettings = this.addressSettingsRepository.getMatch(address.toString());
        QueueImpl queue = addressSettings.isLastValueQueue() ? new LastValueQueue(persistenceID, address, name, filter, pageSubscription, user, durable, temporary, autoCreated, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor()) : new QueueImpl(persistenceID, address, name, filter, pageSubscription, user, durable, temporary, autoCreated, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor());
        return queue;
    }
}

