/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.command.invocation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aesh.console.command.invocation.AeshCommandInvocationProvider;
import org.jboss.aesh.console.command.invocation.CommandInvocationProvider;

public class CommandInvocationServices {
    private final Map<String, CommandInvocationProvider> providers = new ConcurrentHashMap<String, CommandInvocationProvider>();
    public static final String DEFAULT_PROVIDER_NAME = "default";

    public void registerProvider(String name, CommandInvocationProvider provider) {
        this.providers.put(name, provider);
    }

    public void registerDefaultProvider(CommandInvocationProvider p) {
        this.registerProvider(DEFAULT_PROVIDER_NAME, p);
    }

    public CommandInvocationProvider getDefaultCommandInvocationProvider() {
        if (!this.providers.containsKey(DEFAULT_PROVIDER_NAME)) {
            this.providers.put(DEFAULT_PROVIDER_NAME, new AeshCommandInvocationProvider());
        }
        return this.getCommandInvocationProvider(DEFAULT_PROVIDER_NAME);
    }

    public CommandInvocationProvider getCommandInvocationProvider(String name) {
        CommandInvocationProvider provider = this.providers.get(name);
        if (provider == null) {
            return this.getDefaultCommandInvocationProvider();
        }
        return provider;
    }
}

