/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.client.helpers.ContextualModelControllerClient;
import org.jboss.as.controller.client.impl.RemotingModelControllerClient;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.common.context.Contextual;
import org.wildfly.security.auth.client.ElytronXmlParser;

public interface ModelControllerClient
extends Closeable {
    default public ModelNode execute(ModelNode operation) throws IOException {
        return this.execute(Operation.Factory.create(operation), OperationMessageHandler.DISCARD);
    }

    default public ModelNode execute(Operation operation) throws IOException {
        return this.execute(operation, OperationMessageHandler.DISCARD);
    }

    default public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        return this.execute(Operation.Factory.create(operation), messageHandler);
    }

    default public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        try (OperationResponse or = this.executeOperation(operation, messageHandler);){
            ModelNode modelNode = or.getResponseNode();
            return modelNode;
        }
    }

    public OperationResponse executeOperation(Operation var1, OperationMessageHandler var2) throws IOException;

    default public AsyncFuture<ModelNode> executeAsync(ModelNode operation) {
        return this.executeAsync(Operation.Factory.create(operation), OperationMessageHandler.DISCARD);
    }

    default public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        return this.executeAsync(Operation.Factory.create(operation), messageHandler);
    }

    default public AsyncFuture<ModelNode> executeAsync(Operation operation) {
        return this.executeAsync(operation, OperationMessageHandler.DISCARD);
    }

    public AsyncFuture<ModelNode> executeAsync(Operation var1, OperationMessageHandler var2);

    public AsyncFuture<OperationResponse> executeOperationAsync(Operation var1, OperationMessageHandler var2);

    public static class Factory {
        public static ModelControllerClient create(InetAddress address, int port) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(address.getHostAddress()).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, InetAddress address, int port) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).build());
        }

        public static ModelControllerClient create(InetAddress address, int port, CallbackHandler handler) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, InetAddress address, int port, CallbackHandler handler) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).build());
        }

        @Deprecated
        public static ModelControllerClient create(InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setSaslOptions(saslOptions).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(address.getHostAddress()).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).build());
        }

        public static ModelControllerClient create(String hostName, int port) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(hostName).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, String hostName, int port) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHostName(hostName).setPort(port).setProtocol(protocol).build());
        }

        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).build());
        }

        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setSaslOptions(saslOptions).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions, String clientBindAddress) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setClientBindAddress(clientBindAddress).setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setSaslOptions(saslOptions).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout, Map<String, String> saslOptions, String clientBindAddress) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setClientBindAddress(clientBindAddress).setConnectionTimeout(connectionTimeout).setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).setSslContext(sslContext).build());
        }

        @Deprecated
        public static ModelControllerClient create(String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setSaslOptions(saslOptions).build());
        }

        @Deprecated
        public static ModelControllerClient create(String protocol, String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
            return Factory.create(new ModelControllerClientConfiguration.Builder().setHandler(handler).setHostName(hostName).setPort(port).setProtocol(protocol).setSaslOptions(saslOptions).build());
        }

        public static ModelControllerClient create(ModelControllerClientConfiguration configuration) {
            RemotingModelControllerClient result = new RemotingModelControllerClient(configuration);
            Contextual contextual = null;
            URI authenticationConfig = configuration.getAuthenticationConfigUri();
            if (authenticationConfig != null) {
                try {
                    contextual = ElytronXmlParser.parseAuthenticationClientConfiguration(authenticationConfig).create();
                }
                catch (GeneralSecurityException | ConfigXMLParseException e) {
                    throw ControllerClientLogger.ROOT_LOGGER.failedToParseAuthenticationConfig(e, authenticationConfig);
                }
            }
            if (contextual == null) {
                return result;
            }
            return new ContextualModelControllerClient(result, contextual);
        }
    }
}

