/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.security.Attribute;
import org.jboss.as.security.Element;
import org.jboss.as.security.JASPIMappingModuleDefinition;
import org.jboss.as.security.JSSEResourceDefinition;
import org.jboss.as.security.LoginModuleResourceDefinition;
import org.jboss.as.security.MappingModuleDefinition;
import org.jboss.as.security.Namespace;
import org.jboss.as.security.SecurityDomainResourceDefinition;
import org.jboss.as.security.SecuritySubsystemRootResourceDefinition;
import org.jboss.as.security.VaultResourceDefinition;
import org.jboss.as.security.elytron.ElytronIntegrationResourceDefinitions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SecuritySubsystemPersister
implements XMLElementWriter<SubsystemMarshallingContext> {
    public static final SecuritySubsystemPersister INSTANCE = new SecuritySubsystemPersister();

    protected SecuritySubsystemPersister() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (SecuritySubsystemRootResourceDefinition.DEEP_COPY_SUBJECT_MODE.isMarshallable(node) || SecuritySubsystemRootResourceDefinition.INITIALIZE_JACC.isMarshallable(node)) {
            writer.writeEmptyElement(Element.SECURITY_MANAGEMENT.getLocalName());
            if (SecuritySubsystemRootResourceDefinition.DEEP_COPY_SUBJECT_MODE.isMarshallable(node)) {
                SecuritySubsystemRootResourceDefinition.DEEP_COPY_SUBJECT_MODE.marshallAsAttribute(node, (XMLStreamWriter)writer);
            }
            if (SecuritySubsystemRootResourceDefinition.INITIALIZE_JACC.isMarshallable(node)) {
                SecuritySubsystemRootResourceDefinition.INITIALIZE_JACC.marshallAsAttribute(node, (XMLStreamWriter)writer);
            }
        }
        if (node.hasDefined("security-domain") && node.get("security-domain").asInt() > 0) {
            writer.writeStartElement(Element.SECURITY_DOMAINS.getLocalName());
            ModelNode securityDomains = node.get("security-domain");
            for (String policy : securityDomains.keys()) {
                writer.writeStartElement(Element.SECURITY_DOMAIN.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), policy);
                ModelNode policyDetails = securityDomains.get(policy);
                SecurityDomainResourceDefinition.CACHE_TYPE.marshallAsAttribute(policyDetails, (XMLStreamWriter)writer);
                this.writeSecurityDomainContent(writer, policyDetails);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (node.hasDefined("vault")) {
            ModelNode vault = node.get(new String[]{"vault", "classic"});
            writer.writeStartElement(Element.VAULT.getLocalName());
            VaultResourceDefinition.CODE.marshallAsAttribute(vault, (XMLStreamWriter)writer);
            if (vault.hasDefined("vault-options")) {
                ModelNode properties = vault.get("vault-options");
                for (Property prop : properties.asPropertyList()) {
                    writer.writeEmptyElement(Element.VAULT_OPTION.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
                }
            }
            writer.writeEndElement();
        }
        this.writeElytronIntegration(writer, node);
        writer.writeEndElement();
    }

    private void writeSecurityDomainContent(XMLExtendedStreamWriter writer, ModelNode policyDetails) throws XMLStreamException {
        Set keys = policyDetails.keys();
        keys.remove("name");
        keys.remove("cache-type");
        block9: for (String key : keys) {
            Element element = Element.forName(key);
            switch (element) {
                case AUTHENTICATION: {
                    ModelNode kind = policyDetails.get("authentication");
                    for (Property prop : kind.asPropertyList()) {
                        if ("classic".equals(prop.getName())) {
                            this.writeAuthentication(writer, prop.getValue());
                            continue;
                        }
                        if (!"jaspi".equals(prop.getName())) continue;
                        this.writeAuthenticationJaspi(writer, prop.getValue());
                    }
                    continue block9;
                }
                case AUTHORIZATION: {
                    this.writeAuthorization(writer, policyDetails.get(new String[]{"authorization", "classic"}));
                    break;
                }
                case ACL: {
                    this.writeACL(writer, policyDetails.get(new String[]{"acl", "classic"}));
                    break;
                }
                case AUDIT: {
                    this.writeAudit(writer, policyDetails.get(new String[]{"audit", "classic"}));
                    break;
                }
                case IDENTITY_TRUST: {
                    this.writeIdentityTrust(writer, policyDetails.get(new String[]{"identity-trust", "classic"}));
                    break;
                }
                case MAPPING: {
                    this.writeMapping(writer, policyDetails.get(new String[]{"mapping", "classic"}));
                    break;
                }
                case JSSE: {
                    this.writeJSSE(writer, policyDetails.get(new String[]{"jsse", "classic"}));
                }
            }
        }
    }

    private void writeAuthentication(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHENTICATION.getLocalName());
            this.writeLoginModule(writer, modelNode, "login-module");
            writer.writeEndElement();
        }
    }

    private void writeAuthorization(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHORIZATION.getLocalName());
            this.writeLoginModule(writer, modelNode, "policy-module", Element.POLICY_MODULE.getLocalName());
            writer.writeEndElement();
        }
    }

    private void writeACL(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.ACL.getLocalName());
            this.writeLoginModule(writer, modelNode, "acl-module", Element.ACL_MODULE.getLocalName());
            writer.writeEndElement();
        }
    }

    private void writeAudit(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUDIT.getLocalName());
            this.writeLoginModule(writer, modelNode, "provider-module", Element.PROVIDER_MODULE.getLocalName());
            writer.writeEndElement();
        }
    }

    private void writeIdentityTrust(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.IDENTITY_TRUST.getLocalName());
            this.writeLoginModule(writer, modelNode, "trust-module", Element.TRUST_MODULE.getLocalName());
            writer.writeEndElement();
        }
    }

    private void writeMapping(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.MAPPING.getLocalName());
            this.writeLoginModule(writer, modelNode, "mapping-module", "mapping-module");
            writer.writeEndElement();
        }
    }

    private void writeAuthenticationJaspi(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.AUTHENTICATION_JASPI.getLocalName());
            ModelNode moduleStack = modelNode.get("login-module-stack");
            this.writeLoginModuleStack(writer, moduleStack);
            this.writeLoginModule(writer, modelNode, "auth-module", Element.AUTH_MODULE.getLocalName());
            writer.writeEndElement();
        }
    }

    private void writeLoginModuleStack(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            List stacks = modelNode.asPropertyList();
            for (Property stack : stacks) {
                writer.writeStartElement(Element.LOGIN_MODULE_STACK.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), stack.getName());
                this.writeLoginModule(writer, stack.getValue(), "login-module");
                writer.writeEndElement();
            }
        }
    }

    private void writeLoginModule(XMLExtendedStreamWriter writer, ModelNode modelNode, String key) throws XMLStreamException {
        this.writeLoginModule(writer, modelNode, key, Element.LOGIN_MODULE.getLocalName());
    }

    private void writeLoginModule(XMLExtendedStreamWriter writer, ModelNode modelNode, String key, String elementName) throws XMLStreamException {
        if (!modelNode.hasDefined(key)) {
            return;
        }
        ModelNode modules = modelNode.get(key);
        for (Property moduleProp : modules.asPropertyList()) {
            ModelNode module = moduleProp.getValue();
            writer.writeStartElement(elementName);
            if (!moduleProp.getName().equals(module.get("code").asString())) {
                writer.writeAttribute("name", moduleProp.getName());
            }
            LoginModuleResourceDefinition.CODE.marshallAsAttribute(module, (XMLStreamWriter)writer);
            LoginModuleResourceDefinition.FLAG.marshallAsAttribute(module, (XMLStreamWriter)writer);
            MappingModuleDefinition.TYPE.marshallAsAttribute(module, (XMLStreamWriter)writer);
            JASPIMappingModuleDefinition.LOGIN_MODULE_STACK_REF.marshallAsAttribute(module, (XMLStreamWriter)writer);
            LoginModuleResourceDefinition.MODULE.marshallAsAttribute(module, false, (XMLStreamWriter)writer);
            if (module.hasDefined("module-options")) {
                for (ModelNode option : module.get("module-options").asList()) {
                    writer.writeEmptyElement(Element.MODULE_OPTION.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), option.asProperty().getName());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), option.asProperty().getValue().asString());
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeJSSE(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        if (modelNode.isDefined() && modelNode.asInt() > 0) {
            writer.writeStartElement(Element.JSSE.getLocalName());
            JSSEResourceDefinition.KEYSTORE.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.TRUSTSTORE.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.KEYMANAGER.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.TRUSTMANAGER.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.CIPHER_SUITES.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.SERVER_ALIAS.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.SERVICE_AUTH_TOKEN.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.CLIENT_ALIAS.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.CLIENT_AUTH.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.PROTOCOLS.marshallAsAttribute(modelNode, false, (XMLStreamWriter)writer);
            JSSEResourceDefinition.ADDITIONAL_PROPERTIES.marshallAsElement(modelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeElytronIntegration(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        boolean integrationStarted = false;
        integrationStarted |= this.writeSecurityRealms(writer, modelNode, integrationStarted);
        if (integrationStarted |= this.writeTLS(writer, modelNode, integrationStarted)) {
            writer.writeEndElement();
        }
    }

    private boolean writeSecurityRealms(XMLExtendedStreamWriter writer, ModelNode modelNode, boolean integrationStarted) throws XMLStreamException {
        if (modelNode.hasDefined("elytron-realm")) {
            if (!integrationStarted) {
                writer.writeStartElement("elytron-integration");
            }
            writer.writeStartElement("security-realms");
            ModelNode elytronRealms = modelNode.require("elytron-realm");
            for (String realmName : elytronRealms.keys()) {
                writer.writeStartElement("elytron-realm");
                writer.writeAttribute("name", realmName);
                ElytronIntegrationResourceDefinitions.LEGACY_JAAS_CONFIG.marshallAsAttribute(elytronRealms.require(realmName), (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private boolean writeTLS(XMLExtendedStreamWriter writer, ModelNode modelNode, boolean integrationStarted) throws XMLStreamException {
        if (modelNode.hasDefined("elytron-key-store") || modelNode.hasDefined("elytron-trust-store") || modelNode.hasDefined("elytron-key-manager") || modelNode.hasDefined("elytron-trust-manager")) {
            if (!integrationStarted) {
                writer.writeStartElement("elytron-integration");
            }
            writer.writeStartElement("tls");
            this.writeTLSEntity(writer, modelNode, "elytron-key-store");
            this.writeTLSEntity(writer, modelNode, "elytron-trust-store");
            this.writeTLSEntity(writer, modelNode, "elytron-key-manager");
            this.writeTLSEntity(writer, modelNode, "elytron-trust-manager");
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    private void writeTLSEntity(XMLExtendedStreamWriter writer, ModelNode modelNode, String tlsEntityName) throws XMLStreamException {
        if (modelNode.hasDefined(tlsEntityName)) {
            ModelNode tlsEntities = modelNode.require(tlsEntityName);
            for (String entityName : tlsEntities.keys()) {
                writer.writeStartElement(tlsEntityName);
                writer.writeAttribute("name", entityName);
                ElytronIntegrationResourceDefinitions.LEGACY_JSSE_CONFIG.marshallAsAttribute(tlsEntities.require(entityName), (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }
}

