/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.ConcurrentCache;
import com.sun.faces.util.FacesLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

public final class ExpiringConcurrentCache<K, V>
extends ConcurrentCache<K, V> {
    private final ExpiryChecker<K, V> _checker;
    private final ConcurrentMap<K, Future<V>> _cache = new ConcurrentHashMap<K, Future<V>>();
    private static final Logger _LOGGER = FacesLogger.UTIL.getLogger();

    public ExpiringConcurrentCache(ConcurrentCache.Factory<K, V> f, ExpiryChecker<K, V> checker) {
        super(f);
        this._checker = checker;
    }

    /*
     * Loose catch block
     */
    @Override
    public V get(final K key) throws ExecutionException {
        while (true) {
            Callable callable;
            FutureTask ft;
            boolean newlyCached = false;
            FutureTask f = (FutureTask)this._cache.get(key);
            if (f == null && (f = (Future)this._cache.putIfAbsent(key, ft = new FutureTask(callable = new Callable<V>(){

                @Override
                public V call() throws Exception {
                    return ExpiringConcurrentCache.this.getFactory().newInstance(key);
                }
            }))) == null) {
                f = ft;
                ft.run();
                newlyCached = true;
            }
            try {
                Object obj = f.get();
                if (!newlyCached && this._getExpiryChecker().isExpired(key, obj)) {
                    this._cache.remove(key, f);
                    continue;
                }
                return obj;
            }
            catch (CancellationException ce) {
                if (_LOGGER.isLoggable(Level.SEVERE)) {
                    _LOGGER.log(Level.SEVERE, ce.toString(), ce);
                }
                this._cache.remove(key, f);
                continue;
            }
            catch (ExecutionException ee) {
                this._cache.remove(key, f);
                throw ee;
            }
            break;
        }
        catch (InterruptedException ie) {
            throw new FacesException((Throwable)ie);
        }
    }

    @Override
    public boolean containsKey(K key) {
        Future f = (Future)this._cache.get(key);
        if (f != null && f.isDone() && !f.isCancelled()) {
            try {
                Object obj = f.get(0L, TimeUnit.MILLISECONDS);
                if (!this._getExpiryChecker().isExpired(key, obj)) {
                    return true;
                }
                this._cache.remove(key, f);
            }
            catch (TimeoutException obj) {
            }
            catch (CancellationException ce) {
                if (_LOGGER.isLoggable(Level.SEVERE)) {
                    _LOGGER.log(Level.SEVERE, ce.toString(), ce);
                }
            }
            catch (InterruptedException ie) {
                throw new FacesException((Throwable)ie);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return false;
    }

    private ExpiryChecker<K, V> _getExpiryChecker() {
        return this._checker;
    }

    public static interface ExpiryChecker<K, V> {
        public boolean isExpired(K var1, V var2);
    }
}

