/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSAnnotationImpl;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.util.XSGrammarPool;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.ls.LSInput;

public final class XSLoaderImpl
implements XSLoader,
DOMConfiguration {
    private final XSGrammarPool fGrammarPool = new XSGrammarMerger();
    private final XMLSchemaLoader fSchemaLoader = new XMLSchemaLoader();

    public XSLoaderImpl() {
        this.fSchemaLoader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", this.fGrammarPool);
    }

    @Override
    public DOMConfiguration getConfig() {
        return this;
    }

    @Override
    public XSModel loadURIList(StringList uriList) {
        int length = uriList.getLength();
        try {
            this.fGrammarPool.clear();
            for (int i = 0; i < length; ++i) {
                this.fSchemaLoader.loadGrammar(new XMLInputSource(null, uriList.item(i), null));
            }
            return this.fGrammarPool.toXSModel();
        }
        catch (Exception e) {
            this.fSchemaLoader.reportDOMFatalError(e);
            return null;
        }
    }

    @Override
    public XSModel loadInputList(LSInputList is) {
        int length = is.getLength();
        try {
            this.fGrammarPool.clear();
            for (int i = 0; i < length; ++i) {
                this.fSchemaLoader.loadGrammar(this.fSchemaLoader.dom2xmlInputSource(is.item(i)));
            }
            return this.fGrammarPool.toXSModel();
        }
        catch (Exception e) {
            this.fSchemaLoader.reportDOMFatalError(e);
            return null;
        }
    }

    @Override
    public XSModel loadURI(String uri) {
        try {
            this.fGrammarPool.clear();
            return ((XSGrammar)this.fSchemaLoader.loadGrammar(new XMLInputSource(null, uri, null))).toXSModel();
        }
        catch (Exception e) {
            this.fSchemaLoader.reportDOMFatalError(e);
            return null;
        }
    }

    @Override
    public XSModel load(LSInput is) {
        try {
            this.fGrammarPool.clear();
            return ((XSGrammar)this.fSchemaLoader.loadGrammar(this.fSchemaLoader.dom2xmlInputSource(is))).toXSModel();
        }
        catch (Exception e) {
            this.fSchemaLoader.reportDOMFatalError(e);
            return null;
        }
    }

    @Override
    public void setParameter(String name, Object value) throws DOMException {
        this.fSchemaLoader.setParameter(name, value);
    }

    @Override
    public Object getParameter(String name) throws DOMException {
        return this.fSchemaLoader.getParameter(name);
    }

    @Override
    public boolean canSetParameter(String name, Object value) {
        return this.fSchemaLoader.canSetParameter(name, value);
    }

    @Override
    public DOMStringList getParameterNames() {
        return this.fSchemaLoader.getParameterNames();
    }

    private static final class XSGrammarMerger
    extends XSGrammarPool {
        @Override
        public void putGrammar(Grammar grammar) {
            SchemaGrammar cachedGrammar = this.toSchemaGrammar(super.getGrammar(grammar.getGrammarDescription()));
            if (cachedGrammar != null) {
                SchemaGrammar newGrammar = this.toSchemaGrammar(grammar);
                if (newGrammar != null) {
                    this.mergeSchemaGrammars(cachedGrammar, newGrammar);
                }
            } else {
                super.putGrammar(grammar);
            }
        }

        private SchemaGrammar toSchemaGrammar(Grammar grammar) {
            return grammar instanceof SchemaGrammar ? (SchemaGrammar)grammar : null;
        }

        private void mergeSchemaGrammars(SchemaGrammar cachedGrammar, SchemaGrammar newGrammar) {
            XSObject decl;
            int i;
            XSNamedMap map = newGrammar.getComponents((short)2);
            int length = map.getLength();
            for (i = 0; i < length; ++i) {
                decl = (XSElementDecl)map.item(i);
                if (cachedGrammar.getGlobalElementDecl(((XSElementDecl)decl).getName()) != null) continue;
                cachedGrammar.addGlobalElementDecl((XSElementDecl)decl);
            }
            map = newGrammar.getComponents((short)1);
            length = map.getLength();
            for (i = 0; i < length; ++i) {
                decl = (XSAttributeDecl)map.item(i);
                if (cachedGrammar.getGlobalAttributeDecl(((XSAttributeDecl)decl).getName()) != null) continue;
                cachedGrammar.addGlobalAttributeDecl((XSAttributeDecl)decl);
            }
            map = newGrammar.getComponents((short)3);
            length = map.getLength();
            for (i = 0; i < length; ++i) {
                decl = (XSTypeDefinition)map.item(i);
                if (cachedGrammar.getGlobalTypeDecl(decl.getName()) != null) continue;
                cachedGrammar.addGlobalTypeDecl((XSTypeDefinition)decl);
            }
            map = newGrammar.getComponents((short)5);
            length = map.getLength();
            for (i = 0; i < length; ++i) {
                decl = (XSAttributeGroupDecl)map.item(i);
                if (cachedGrammar.getGlobalAttributeGroupDecl(((XSAttributeGroupDecl)decl).getName()) != null) continue;
                cachedGrammar.addGlobalAttributeGroupDecl((XSAttributeGroupDecl)decl);
            }
            map = newGrammar.getComponents((short)7);
            length = map.getLength();
            for (i = 0; i < length; ++i) {
                decl = (XSGroupDecl)map.item(i);
                if (cachedGrammar.getGlobalGroupDecl(((XSGroupDecl)decl).getName()) != null) continue;
                cachedGrammar.addGlobalGroupDecl((XSGroupDecl)decl);
            }
            map = newGrammar.getComponents((short)11);
            length = map.getLength();
            for (i = 0; i < length; ++i) {
                decl = (XSNotationDecl)map.item(i);
                if (cachedGrammar.getGlobalNotationDecl(((XSNotationDecl)decl).getName()) != null) continue;
                cachedGrammar.addGlobalNotationDecl((XSNotationDecl)decl);
            }
            XSObjectList annotations = newGrammar.getAnnotations();
            length = annotations.getLength();
            for (int i2 = 0; i2 < length; ++i2) {
                cachedGrammar.addAnnotation((XSAnnotationImpl)annotations.item(i2));
            }
        }

        @Override
        public boolean containsGrammar(XMLGrammarDescription desc) {
            return false;
        }

        @Override
        public Grammar getGrammar(XMLGrammarDescription desc) {
            return null;
        }

        @Override
        public Grammar retrieveGrammar(XMLGrammarDescription desc) {
            return null;
        }

        @Override
        public Grammar[] retrieveInitialGrammarSet(String grammarType) {
            return new Grammar[0];
        }
    }
}

