/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.Reducer;

public class ReduceCommand<KOut, VOut>
extends BaseRpcCommand
implements CancellableCommand {
    public static final int COMMAND_ID = 31;
    private Set<KOut> keys = new HashSet<KOut>();
    private Reducer<KOut, VOut> reducer;
    private String taskId;
    private boolean useIntermediateSharedCache;
    private MapReduceManager mrManager;
    private UUID uuid;
    private String resultCacheName;

    private ReduceCommand() {
        super(null);
    }

    public ReduceCommand(String cacheName) {
        super(cacheName);
    }

    public ReduceCommand(String taskId, Reducer<KOut, VOut> reducer, String cacheName, Collection<KOut> inputKeys) {
        super(cacheName);
        this.taskId = taskId;
        if (inputKeys != null && !inputKeys.isEmpty()) {
            this.keys.addAll(inputKeys);
        }
        this.reducer = reducer;
        this.uuid = UUID.randomUUID();
    }

    public void init(MapReduceManager mrManager) {
        this.mrManager = mrManager;
    }

    @Override
    public Object perform(InvocationContext context) throws Throwable {
        if (this.emitsIntoResultingCache()) {
            this.mrManager.reduce(this, this.getResultCacheName());
            return Collections.emptyMap();
        }
        return this.mrManager.reduce(this);
    }

    public boolean isUseIntermediateSharedCache() {
        return this.useIntermediateSharedCache;
    }

    public void setUseIntermediateSharedCache(boolean useIntermediateSharedCache) {
        this.useIntermediateSharedCache = useIntermediateSharedCache;
    }

    public boolean emitsIntoResultingCache() {
        return this.resultCacheName != null && !this.resultCacheName.isEmpty();
    }

    public String getResultCacheName() {
        return this.resultCacheName;
    }

    public void setResultCacheName(String resultCacheName) {
        this.resultCacheName = resultCacheName;
    }

    public Set<KOut> getKeys() {
        return this.keys;
    }

    public Reducer<KOut, VOut> getReducer() {
        return this.reducer;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public byte getCommandId() {
        return 31;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.taskId);
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeObject(this.reducer);
        output.writeBoolean(this.useIntermediateSharedCache);
        MarshallUtil.marshallUUID((UUID)this.uuid, (ObjectOutput)output, (boolean)false);
        MarshallUtil.marshallString((String)this.resultCacheName, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.taskId = input.readUTF();
        this.keys = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.reducer = (Reducer)input.readObject();
        this.useIntermediateSharedCache = input.readBoolean();
        this.uuid = MarshallUtil.unmarshallUUID((ObjectInput)input, (boolean)false);
        this.resultCacheName = MarshallUtil.unmarshallString((ObjectInput)input);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReduceCommand)) {
            return false;
        }
        ReduceCommand other = (ReduceCommand)obj;
        return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReduceCommand [keys=" + this.keys + ", taskId=" + this.taskId + "]";
    }
}

