/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jgroups.Address;
import org.jgroups.util.Util;
import org.wildfly.clustering.infinispan.spi.persistence.BinaryKeyFormat;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.server.group.AddressableNode;

public class AddressableNodeExternalizer
extends BinaryKeyFormat<AddressableNode>
implements Externalizer<AddressableNode> {
    public AddressableNodeExternalizer() {
        super(AddressableNode.class, AddressableNodeExternalizer::read, AddressableNodeExternalizer::write);
    }

    private static AddressableNode read(DataInput input) throws IOException {
        try {
            Address jgroupsAddress = Util.readAddress((DataInput)input);
            String name = input.readUTF();
            byte[] address = new byte[input.readInt()];
            input.readFully(address);
            int port = input.readInt();
            return new AddressableNode(jgroupsAddress, name, new InetSocketAddress(InetAddress.getByAddress(address), port));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static void write(DataOutput output, AddressableNode node) throws IOException {
        try {
            Util.writeAddress((Address)node.getAddress(), (DataOutput)output);
            output.writeUTF(node.getName());
            InetSocketAddress socketAddress = node.getSocketAddress();
            byte[] address = socketAddress.getAddress().getAddress();
            output.writeInt(address.length);
            output.write(address);
            output.writeInt(socketAddress.getPort());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public AddressableNode readObject(ObjectInput input) throws IOException {
        return AddressableNodeExternalizer.read(input);
    }

    public void writeObject(ObjectOutput output, AddressableNode node) throws IOException {
        AddressableNodeExternalizer.write(output, node);
    }
}

