/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.provider.ServiceProviderRegistry;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistry;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistryConfiguration;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrationFactoryAdapter;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;

public class CacheServiceProviderRegistryBuilder<T>
implements CapabilityServiceBuilder<ServiceProviderRegistry<T>>,
CacheServiceProviderRegistryConfiguration<T> {
    private final ServiceName name;
    private final String containerName;
    private final String cacheName;
    private volatile ValueDependency<CommandDispatcherFactory> dispatcherFactory;
    private volatile ValueDependency<Group> group;
    private volatile ValueDependency<Cache> cache;

    public CacheServiceProviderRegistryBuilder(ServiceName name, String containerName, String cacheName) {
        this.name = name;
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<ServiceProviderRegistry<T>> configure(CapabilityServiceSupport support) {
        this.cache = new InjectedValueDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.containerName, this.cacheName), Cache.class);
        this.dispatcherFactory = new InjectedValueDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, this.containerName), CommandDispatcherFactory.class);
        this.group = new InjectedValueDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.cacheName), Group.class);
        return this;
    }

    public ServiceBuilder<ServiceProviderRegistry<T>> build(ServiceTarget target) {
        Function<CacheServiceProviderRegistry, ServiceProviderRegistry> mapper = registry -> new ServiceProviderRegistrationFactoryAdapter(registry);
        Supplier<CacheServiceProviderRegistry> supplier = () -> new CacheServiceProviderRegistry(this);
        SuppliedValueService service = new SuppliedValueService(mapper, supplier, Consumers.close());
        ServiceBuilder builder = new AsynchronousServiceBuilder(this.name, (Service)service).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
        Stream.of(this.cache, this.dispatcherFactory, this.group).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public Object getId() {
        return this.getServiceName();
    }

    @Override
    public Group getGroup() {
        return (Group)this.group.getValue();
    }

    @Override
    public Cache<T, Set<Node>> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.getValue();
    }

    @Override
    public Batcher<? extends Batch> getBatcher() {
        return new InfinispanBatcher(this.getCache());
    }
}

