/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.AuthorizationFailureException;

public class RunAsPrincipalInterceptor
implements Interceptor {
    private static final String ANONYMOUS_PRINCIPAL = "anonymous";
    private final String runAsPrincipal;

    public RunAsPrincipalInterceptor(String runAsPrincipal) {
        this.runAsPrincipal = runAsPrincipal;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof EJBComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, EJBComponent.class);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        SecurityDomain securityDomain = (SecurityDomain)context.getPrivateData(SecurityDomain.class);
        Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        SecurityIdentity currentIdentity = securityDomain.getCurrentSecurityIdentity();
        SecurityIdentity oldIncomingRunAsIdentity = ejbComponent.getIncomingRunAsIdentity();
        try {
            SecurityIdentity newIdentity;
            if (this.runAsPrincipal.equals(ANONYMOUS_PRINCIPAL)) {
                try {
                    newIdentity = currentIdentity.createRunAsAnonymous();
                }
                catch (AuthorizationFailureException ex) {
                    newIdentity = currentIdentity.createRunAsAnonymous(false);
                }
            } else if (!this.runAsPrincipalExists(securityDomain, this.runAsPrincipal)) {
                newIdentity = securityDomain.createAdHocIdentity(this.runAsPrincipal);
            } else {
                try {
                    newIdentity = currentIdentity.createRunAsIdentity(this.runAsPrincipal);
                }
                catch (AuthorizationFailureException ex) {
                    newIdentity = currentIdentity.createRunAsIdentity(this.runAsPrincipal, false);
                }
            }
            ejbComponent.setIncomingRunAsIdentity(currentIdentity);
            Object ex = newIdentity.runAs((PrivilegedExceptionAction)context);
            return ex;
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new RuntimeException(e);
            }
            throw e;
        }
        finally {
            ejbComponent.setIncomingRunAsIdentity(oldIncomingRunAsIdentity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runAsPrincipalExists(SecurityDomain securityDomain, String runAsPrincipal) throws RealmUnavailableException {
        RealmIdentity realmIdentity = null;
        try {
            realmIdentity = securityDomain.getIdentity(runAsPrincipal);
            boolean bl = realmIdentity.exists();
            return bl;
        }
        finally {
            if (realmIdentity != null) {
                realmIdentity.dispose();
            }
        }
    }
}

