/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import nu.xom.Builder;
import nu.xom.IllegalCharacterDataException;
import nu.xom.IllegalDataException;
import nu.xom.IllegalNameException;
import nu.xom.MalformedURIException;
import nu.xom.URIUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class Verifier {
    private static final byte XML_CHARACTER = 1;
    private static final byte NAME_CHARACTER = 2;
    private static final byte NAME_START_CHARACTER = 4;
    private static final byte NCNAME_CHARACTER = 8;
    private static byte[] flags = null;
    private static boolean[] C0Table;
    private static URICache cache;
    private static XMLReader parser;

    private Verifier() {
    }

    private static void loadFlags(ClassLoader loader) {
        FilterInputStream in = null;
        try {
            InputStream raw = loader.getResourceAsStream("nu/xom/characters.dat");
            if (raw == null) {
                throw new RuntimeException("Broken XOM installation: could not load nu/xom/characters.dat");
            }
            in = new DataInputStream(raw);
            flags = new byte[65536];
            ((DataInputStream)in).readFully(flags);
        }
        catch (IOException ex) {
            throw new RuntimeException("Broken XOM installation: could not load nu/xom/characters.dat");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static void checkNCName(String name) {
        char first;
        int length;
        if (name == null) {
            Verifier.throwIllegalNameException(name, "NCNames cannot be null");
        }
        if ((length = name.length()) == 0) {
            Verifier.throwIllegalNameException(name, "NCNames cannot be empty");
        }
        if ((flags[first = name.charAt(0)] & 4) == 0) {
            Verifier.throwIllegalNameException(name, "NCNames cannot start with the character " + Integer.toHexString(first));
        }
        for (int i = 1; i < length; ++i) {
            char c = name.charAt(i);
            if ((flags[c] & 8) != 0) continue;
            if (c == ':') {
                Verifier.throwIllegalNameException(name, "NCNames cannot contain colons");
                continue;
            }
            Verifier.throwIllegalNameException(name, "0x" + Integer.toHexString(c) + " is not a legal NCName character");
        }
    }

    private static void throwIllegalNameException(String name, String message) {
        IllegalNameException ex = new IllegalNameException(message);
        ex.setData(name);
        throw ex;
    }

    private static void throwIllegalCharacterDataException(String data, String message) {
        IllegalCharacterDataException ex = new IllegalCharacterDataException(message);
        ex.setData(data);
        throw ex;
    }

    private static void throwMalformedURIException(String uri, String message) {
        MalformedURIException ex = new MalformedURIException(message);
        ex.setData(uri);
        throw ex;
    }

    static void checkPCDATA(String text) {
        if (text == null) {
            throw new IllegalCharacterDataException("Null text");
        }
        char[] data = text.toCharArray();
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            char result = data[i];
            if (result >= '\ud800' && result <= '\udbff') {
                try {
                    char low = data[i + 1];
                    if (low < '\udc00' || low > '\udfff') {
                        IllegalCharacterDataException ex = new IllegalCharacterDataException("Bad surrogate pair");
                        ex.setData(text);
                        throw ex;
                    }
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    IllegalCharacterDataException ide = new IllegalCharacterDataException("Bad Surrogate Pair", ex);
                    ide.setData(text);
                    throw ide;
                }
            }
            if ((flags[result] & 1) != 0) continue;
            Verifier.throwIllegalCharacterDataException(text, "0x" + Integer.toHexString(result) + " is not allowed in XML content");
        }
    }

    static void checkURIReference(String uri) {
        if (uri == null || uri.length() == 0) {
            return;
        }
        URIUtil.ParsedURI parsed = new URIUtil.ParsedURI(uri);
        try {
            if (parsed.scheme != null) {
                Verifier.checkScheme(parsed.scheme);
            }
            if (parsed.authority != null) {
                Verifier.checkAuthority(parsed.authority);
            }
            Verifier.checkPath(parsed.path);
            if (parsed.fragment != null) {
                Verifier.checkFragment(parsed.fragment);
            }
            if (parsed.query != null) {
                Verifier.checkQuery(parsed.query);
            }
        }
        catch (MalformedURIException ex) {
            ex.setData(uri);
            throw ex;
        }
    }

    private static void checkQuery(String query) {
        int length = query.length();
        for (int i = 0; i < length; ++i) {
            char c = query.charAt(i);
            if (c == '%') {
                try {
                    if (!Verifier.isHexDigit(query.charAt(i + 1)) || !Verifier.isHexDigit(query.charAt(i + 2))) {
                        Verifier.throwMalformedURIException(query, "Bad percent escape sequence");
                    }
                }
                catch (StringIndexOutOfBoundsException ex) {
                    Verifier.throwMalformedURIException(query, "Bad percent escape sequence");
                }
                i += 2;
                continue;
            }
            if (Verifier.isQueryCharacter(c)) continue;
            throw new MalformedURIException("Illegal query character " + c);
        }
    }

    private static boolean isQueryCharacter(char c) {
        switch (c) {
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return false;
            }
            case '$': {
                return true;
            }
            case '%': {
                return false;
            }
            case '&': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return true;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return true;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return true;
            }
            case '@': {
                return true;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
            case '{': {
                return false;
            }
            case '|': {
                return false;
            }
            case '}': {
                return false;
            }
            case '~': {
                return true;
            }
        }
        return false;
    }

    private static void checkFragment(String fragment) {
        Verifier.checkQuery(fragment);
    }

    private static void checkPath(String path) {
        int length = path.length();
        char[] text = path.toCharArray();
        for (int i = 0; i < length; ++i) {
            char c = text[i];
            if (c == '/') {
                if (i >= length - 1 || text[i + 1] != '/') continue;
                Verifier.throwMalformedURIException(path, "Double slash (//) in path");
                continue;
            }
            if (c == '%') {
                try {
                    if (!Verifier.isHexDigit(text[i + 1]) || !Verifier.isHexDigit(text[i + 2])) {
                        Verifier.throwMalformedURIException(path, "Bad percent escape sequence");
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    Verifier.throwMalformedURIException(path, "Bad percent escape sequence");
                }
                i += 2;
                continue;
            }
            if (Verifier.isPathCharacter(c)) continue;
            Verifier.throwMalformedURIException(path, "Illegal path character " + c);
        }
    }

    private static void checkAuthority(String authority) {
        int colon;
        String userInfo = null;
        String host = null;
        String port = null;
        int atSign = authority.indexOf(64);
        if (atSign != -1) {
            userInfo = authority.substring(0, atSign);
            authority = authority.substring(atSign + 1);
        }
        if (authority.startsWith("[")) {
            colon = authority.indexOf("]:");
            if (colon != -1) {
                ++colon;
            }
        } else {
            colon = authority.indexOf(58);
        }
        if (colon != -1) {
            host = authority.substring(0, colon);
            port = authority.substring(colon + 1);
        } else {
            host = authority;
        }
        if (userInfo != null) {
            Verifier.checkUserInfo(userInfo);
        }
        if (port != null) {
            Verifier.checkPort(port);
        }
        Verifier.checkHost(host);
    }

    private static void checkHost(String host) {
        int length = host.length();
        if (length == 0) {
            return;
        }
        char[] text = host.toCharArray();
        if (text[0] == '[') {
            if (text[length - 1] != ']') {
                throw new MalformedURIException("Missing closing ]");
            }
            Verifier.checkIP6Address(host.substring(1, length - 1));
        } else {
            if (length > 255) {
                throw new MalformedURIException("Host name too long: " + host);
            }
            for (int i = 0; i < length; ++i) {
                char c = text[i];
                if (c == '%') {
                    try {
                        if (!Verifier.isHexDigit(text[i + 1]) || !Verifier.isHexDigit(text[i + 2])) {
                            Verifier.throwMalformedURIException(host, "Bad percent escape sequence");
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        Verifier.throwMalformedURIException(host, "Bad percent escape sequence");
                    }
                    i += 2;
                    continue;
                }
                if (Verifier.isRegNameCharacter(c)) continue;
                Verifier.throwMalformedURIException(host, "Illegal host character " + c);
            }
        }
    }

    private static boolean isRegNameCharacter(char c) {
        switch (c) {
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return false;
            }
            case '$': {
                return true;
            }
            case '%': {
                return false;
            }
            case '&': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return false;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return false;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return false;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
            case '{': {
                return false;
            }
            case '|': {
                return false;
            }
            case '}': {
                return false;
            }
            case '~': {
                return true;
            }
        }
        return false;
    }

    private static void checkPort(String port) {
        for (int i = port.length() - 1; i >= 0; --i) {
            char c = port.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new MalformedURIException("Bad port: " + port);
        }
    }

    private static void checkUserInfo(String userInfo) {
        int length = userInfo.length();
        for (int i = 0; i < length; ++i) {
            char c = userInfo.charAt(i);
            if (c == '%') {
                try {
                    if (!Verifier.isHexDigit(userInfo.charAt(i + 1)) || !Verifier.isHexDigit(userInfo.charAt(i + 2))) {
                        Verifier.throwMalformedURIException(userInfo, "Bad percent escape sequence");
                    }
                }
                catch (StringIndexOutOfBoundsException ex) {
                    Verifier.throwMalformedURIException(userInfo, "Bad percent escape sequence");
                }
                i += 2;
                continue;
            }
            if (Verifier.isUserInfoCharacter(c)) continue;
            throw new MalformedURIException("Bad user info: " + userInfo);
        }
    }

    private static void checkScheme(String scheme) {
        if ("http".equals(scheme)) {
            return;
        }
        if (scheme.length() == 0) {
            throw new MalformedURIException("URIs cannot begin with a colon");
        }
        char c = scheme.charAt(0);
        if (!Verifier.isAlpha(c)) {
            throw new MalformedURIException("Illegal initial scheme character " + c);
        }
        for (int i = scheme.length() - 1; i >= 1; --i) {
            c = scheme.charAt(i);
            if (Verifier.isSchemeCharacter(c)) continue;
            throw new MalformedURIException("Illegal scheme character " + c);
        }
    }

    private static void checkIP6Address(String ip6Address) {
        StringTokenizer st = new StringTokenizer(ip6Address, ":", true);
        int numTokens = st.countTokens();
        if (numTokens > 15 || numTokens < 2) {
            throw new MalformedURIException("Illegal IP6 host address: " + ip6Address);
        }
        for (int i = 0; i < numTokens; ++i) {
            String hexPart = st.nextToken();
            if (":".equals(hexPart)) continue;
            try {
                int part = Integer.parseInt(hexPart, 16);
                if (part >= 0) continue;
                throw new MalformedURIException("Illegal IP6 host address: " + ip6Address);
            }
            catch (NumberFormatException ex) {
                if (i == numTokens - 1) {
                    Verifier.checkIP4Address(hexPart, ip6Address);
                    continue;
                }
                Verifier.throwMalformedURIException(ip6Address, "Illegal IP6 host address: " + ip6Address);
            }
        }
        if (ip6Address.indexOf("::") != ip6Address.lastIndexOf("::")) {
            throw new MalformedURIException("Illegal IP6 host address: " + ip6Address);
        }
    }

    private static void checkIP4Address(String address, String ip6Address) {
        StringTokenizer st = new StringTokenizer(address, ".");
        int numTokens = st.countTokens();
        if (numTokens != 4) {
            throw new MalformedURIException("Illegal IP6 host address: " + ip6Address);
        }
        for (int i = 0; i < 4; ++i) {
            String decPart = st.nextToken();
            try {
                int dec = Integer.parseInt(decPart);
                if (dec <= 255 && dec >= 0) continue;
                throw new MalformedURIException("Illegal IP6 host address: " + ip6Address);
            }
            catch (NumberFormatException ex) {
                throw new MalformedURIException("Illegal IP6 host address: " + ip6Address);
            }
        }
    }

    static void checkXMLName(String name) {
        char first;
        int length;
        if (name == null) {
            Verifier.throwIllegalNameException(name, "XML names cannot be null");
        }
        if ((length = name.length()) == 0) {
            Verifier.throwIllegalNameException(name, "XML names cannot be empty");
        }
        if ((flags[first = name.charAt(0)] & 4) == 0) {
            Verifier.throwIllegalNameException(name, "XML names cannot start with the character " + Integer.toHexString(first));
        }
        for (int i = 1; i < length; ++i) {
            char c = name.charAt(i);
            if ((flags[c] & 2) != 0) continue;
            Verifier.throwIllegalNameException(name, "0x" + Integer.toHexString(c) + " is not a legal name character");
        }
    }

    static boolean isXMLSpaceCharacter(char c) {
        if (c > ' ') {
            return false;
        }
        return C0Table[c];
    }

    private static boolean isHexDigit(char c) {
        switch (c) {
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return false;
            }
            case ';': {
                return false;
            }
            case '<': {
                return false;
            }
            case '=': {
                return false;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return false;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return false;
            }
            case 'H': {
                return false;
            }
            case 'I': {
                return false;
            }
            case 'J': {
                return false;
            }
            case 'K': {
                return false;
            }
            case 'L': {
                return false;
            }
            case 'M': {
                return false;
            }
            case 'N': {
                return false;
            }
            case 'O': {
                return false;
            }
            case 'P': {
                return false;
            }
            case 'Q': {
                return false;
            }
            case 'R': {
                return false;
            }
            case 'S': {
                return false;
            }
            case 'T': {
                return false;
            }
            case 'U': {
                return false;
            }
            case 'V': {
                return false;
            }
            case 'W': {
                return false;
            }
            case 'X': {
                return false;
            }
            case 'Y': {
                return false;
            }
            case 'Z': {
                return false;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return false;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
        }
        return false;
    }

    static void checkAbsoluteURIReference(String uri) {
        if (cache.contains(uri)) {
            return;
        }
        URIUtil.ParsedURI parsed = new URIUtil.ParsedURI(uri);
        try {
            if (parsed.scheme == null) {
                Verifier.throwMalformedURIException(uri, "Missing scheme in absolute URI reference");
            }
            Verifier.checkScheme(parsed.scheme);
            if (parsed.authority != null) {
                Verifier.checkAuthority(parsed.authority);
            }
            Verifier.checkPath(parsed.path);
            if (parsed.fragment != null) {
                Verifier.checkFragment(parsed.fragment);
            }
            if (parsed.query != null) {
                Verifier.checkQuery(parsed.query);
            }
            cache.put(uri);
        }
        catch (MalformedURIException ex) {
            ex.setData(uri);
            throw ex;
        }
    }

    static boolean isAlpha(char c) {
        switch (c) {
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return false;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
        }
        return false;
    }

    static boolean isSchemeCharacter(char c) {
        switch (c) {
            case '+': {
                return true;
            }
            case ',': {
                return false;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return false;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return false;
            }
            case ';': {
                return false;
            }
            case '<': {
                return false;
            }
            case '=': {
                return false;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return false;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return false;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
        }
        return false;
    }

    private static boolean isPathCharacter(char c) {
        switch (c) {
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return false;
            }
            case '$': {
                return true;
            }
            case '%': {
                return false;
            }
            case '&': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return false;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return true;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return true;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
            case '{': {
                return false;
            }
            case '|': {
                return false;
            }
            case '}': {
                return false;
            }
            case '~': {
                return true;
            }
        }
        return false;
    }

    private static boolean isUserInfoCharacter(char c) {
        switch (c) {
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return false;
            }
            case '$': {
                return true;
            }
            case '%': {
                return false;
            }
            case '&': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return true;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return true;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return false;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
            case '{': {
                return false;
            }
            case '|': {
                return false;
            }
            case '}': {
                return false;
            }
            case '~': {
                return true;
            }
        }
        return false;
    }

    static void checkAbsoluteURI(String uri) {
        URIUtil.ParsedURI parsed = new URIUtil.ParsedURI(uri);
        try {
            if (parsed.scheme == null) {
                Verifier.throwMalformedURIException(uri, "Missing scheme in absolute URI");
            }
            Verifier.checkScheme(parsed.scheme);
            if (parsed.authority != null) {
                Verifier.checkAuthority(parsed.authority);
            }
            Verifier.checkPath(parsed.path);
            if (parsed.fragment != null) {
                Verifier.throwMalformedURIException(uri, "URIs cannot have fragment identifiers");
            }
            if (parsed.query != null) {
                Verifier.checkQuery(parsed.query);
            }
        }
        catch (MalformedURIException ex) {
            ex.setData(uri);
            throw ex;
        }
    }

    static synchronized void checkInternalDTDSubset(String subset) {
        if (parser == null) {
            final InputSource empty = new InputSource(new EmptyReader());
            parser = Builder.findParser(false);
            parser.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicID, String systemID) {
                    return empty;
                }
            });
        }
        String doc = "<!DOCTYPE a [" + subset + "]><a/>";
        try {
            InputSource source = new InputSource(new StringReader(doc));
            source.setSystemId("http://www.example.org/");
            parser.parse(source);
        }
        catch (SAXException ex) {
            IllegalDataException idex = new IllegalDataException("Malformed internal DTD subset: " + ex.getMessage(), ex);
            idex.setData(subset);
            throw idex;
        }
        catch (IOException ex) {
            throw new RuntimeException("BUG: I don't think this can happen");
        }
    }

    static {
        ClassLoader loader = Verifier.class.getClassLoader();
        if (loader != null) {
            Verifier.loadFlags(loader);
        }
        if (flags == null) {
            loader = Thread.currentThread().getContextClassLoader();
            Verifier.loadFlags(loader);
        }
        C0Table = new boolean[33];
        Verifier.C0Table[10] = true;
        Verifier.C0Table[13] = true;
        Verifier.C0Table[9] = true;
        Verifier.C0Table[32] = true;
        cache = new URICache();
    }

    private static class EmptyReader
    extends Reader {
        private EmptyReader() {
        }

        @Override
        public int read(char[] text, int start, int length) throws IOException {
            return -1;
        }

        @Override
        public void close() {
        }
    }

    private static final class URICache {
        private static final int LOAD = 6;
        private String[] cache = new String[6];
        private int position = 0;

        private URICache() {
        }

        synchronized boolean contains(String s) {
            for (int i = 0; i < 6; ++i) {
                if (s != this.cache[i]) continue;
                return true;
            }
            return false;
        }

        synchronized void put(String s) {
            this.cache[this.position] = s;
            ++this.position;
            if (this.position == 6) {
                this.position = 0;
            }
        }
    }
}

