/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.HashMap;
import java.util.Map;
import nu.xom.Element;
import nu.xom.NamespaceConflictException;
import nu.xom.Verifier;
import org.jaxen.NamespaceContext;

public final class XPathContext {
    private Map namespaces = new HashMap();

    public XPathContext(String prefix, String uri) {
        this();
        this.addNamespace(prefix, uri);
    }

    public XPathContext() {
        this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public void addNamespace(String prefix, String uri) {
        if ("xml".equals(prefix) && !"http://www.w3.org/XML/1998/namespace".equals(uri)) {
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + uri);
        }
        if ("".equals(uri)) {
            uri = null;
        }
        if (prefix == null) {
            throw new NullPointerException("Prefixes used in XPath expressions cannot be null");
        }
        if ("".equals(prefix)) {
            throw new NamespaceConflictException("XPath expressions do not use the default namespace");
        }
        Verifier.checkNCName(prefix);
        if (uri == null) {
            this.namespaces.remove(prefix);
        } else {
            this.namespaces.put(prefix, uri);
        }
    }

    public static XPathContext makeNamespaceContext(Element element) {
        XPathContext context = new XPathContext();
        context.namespaces = element.getNamespacePrefixesInScope();
        return context;
    }

    NamespaceContext getJaxenContext() {
        return new JaxenNamespaceContext();
    }

    public String lookup(String prefix) {
        if ("".equals(prefix)) {
            return null;
        }
        return (String)this.namespaces.get(prefix);
    }

    private class JaxenNamespaceContext
    implements NamespaceContext {
        private JaxenNamespaceContext() {
        }

        public String translateNamespacePrefixToUri(String prefix) {
            return XPathContext.this.lookup(prefix);
        }
    }
}

