/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting.management;

import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.management.BaseNativeInterfaceResourceDefinition;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.as.remoting.management.ManagementChannelOpenListenerService;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

public final class ManagementRemotingServices
extends RemotingServices {
    public static final ServiceName MANAGEMENT_ENDPOINT = RemotingServices.REMOTING_BASE.append(new String[]{"endpoint", "management"});
    public static final ServiceName SHUTDOWN_EXECUTOR_NAME = MANAGEMENT_ENDPOINT.append(new String[]{"shutdown", "executor"});
    public static final String MANAGEMENT_CHANNEL = "management";
    public static final String DOMAIN_CHANNEL = "domain";
    public static final String SERVER_CHANNEL = "server";
    public static final String MANAGEMENT_CONNECTOR = "management";
    public static final String HTTP_CONNECTOR = "http-management";
    public static final String HTTPS_CONNECTOR = "https-management";
    private static final String USE_MGMT_ENDPOINT = "use-management-endpoint";

    private ManagementRemotingServices() {
    }

    public static void installDomainConnectorServices(OperationContext context, ServiceTarget serviceTarget, ServiceName endpointName, ServiceName networkInterfaceBinding, int port, OptionMap options, ServiceName securityRealm, ServiceName saslAuthenticationFactory, ServiceName sslContext) {
        String sbmCap = "org.wildfly.management.socket-binding-manager";
        ServiceName sbmName = context.hasOptionalCapability(sbmCap, BaseNativeInterfaceResourceDefinition.NATIVE_MANAGEMENT_RUNTIME_CAPABILITY.getName(), null) ? context.getCapabilityServiceName(sbmCap, SocketBindingManager.class) : null;
        ManagementRemotingServices.installConnectorServicesForNetworkInterfaceBinding(serviceTarget, endpointName, "management", networkInterfaceBinding, port, options, securityRealm, saslAuthenticationFactory, sslContext, sbmName);
    }

    public static void installManagementChannelOpenListenerService(ServiceTarget serviceTarget, ServiceName endpointName, String channelName, ServiceName operationHandlerName, OptionMap options, boolean onDemand) {
        ManagementChannelOpenListenerService channelOpenListenerService = new ManagementChannelOpenListenerService(channelName, options);
        ServiceBuilder builder = serviceTarget.addService(channelOpenListenerService.getServiceName(endpointName), (Service)channelOpenListenerService).addDependency(endpointName, Endpoint.class, channelOpenListenerService.getEndpointInjector()).addDependency(operationHandlerName, ManagementChannelInitialization.class, channelOpenListenerService.getOperationHandlerInjector()).addDependency(ManagementChannelRegistryService.SERVICE_NAME, ManagementChannelRegistryService.class, channelOpenListenerService.getRegistry()).addDependency(SHUTDOWN_EXECUTOR_NAME, ExecutorService.class, channelOpenListenerService.getExecutorServiceInjectedValue()).setInitialMode(onDemand ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.ACTIVE);
        builder.install();
    }

    public static void removeManagementChannelOpenListenerService(OperationContext context, ServiceName endpointName, String channelName) {
        context.removeService(RemotingServices.channelServiceName(endpointName, channelName));
    }

    public static void installManagementChannelServices(ServiceTarget serviceTarget, ServiceName endpointName, AbstractModelControllerOperationHandlerFactoryService operationHandlerService, ServiceName modelControllerName, String channelName, ServiceName executorServiceName, ServiceName scheduledExecutorServiceName) {
        OptionMap options = OptionMap.EMPTY;
        ServiceName operationHandlerName = endpointName.append(new String[]{channelName}).append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
        serviceTarget.addService(operationHandlerName, (Service)operationHandlerService).addDependency(modelControllerName, ModelController.class, (Injector)operationHandlerService.getModelControllerInjector()).addDependency(executorServiceName, ExecutorService.class, (Injector)operationHandlerService.getExecutorInjector()).addDependency(scheduledExecutorServiceName, ScheduledExecutorService.class, (Injector)operationHandlerService.getScheduledExecutorInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        ManagementRemotingServices.installManagementChannelOpenListenerService(serviceTarget, endpointName, channelName, operationHandlerName, options, false);
    }

    public static void removeManagementChannelServices(OperationContext context, ServiceName endpointName, String channelName) {
        ManagementRemotingServices.removeManagementChannelOpenListenerService(context, endpointName, channelName);
        ServiceName operationHandlerName = endpointName.append(new String[]{channelName}).append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
        context.removeService(operationHandlerName);
    }

    public static void isManagementResourceRemoveable(OperationContext context, PathAddress otherManagementEndpoint) throws OperationFailedException {
        ModelNode remotingConnector;
        try {
            remotingConnector = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"jmx"), PathElement.pathElement((String)"remoting-connector", (String)"jmx")}), false).getModel();
        }
        catch (NoSuchElementException ex) {
            return;
        }
        if (!remotingConnector.hasDefined(USE_MGMT_ENDPOINT) || remotingConnector.hasDefined(USE_MGMT_ENDPOINT) && context.resolveExpressions(remotingConnector.get(USE_MGMT_ENDPOINT)).asBoolean(true)) {
            try {
                context.readResourceFromRoot(otherManagementEndpoint, false);
            }
            catch (NoSuchElementException ex) {
                throw RemotingLogger.ROOT_LOGGER.couldNotRemoveResource(context.getCurrentAddress());
            }
        }
    }
}

