/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.transform.TransformerOperationAttachment;
import org.jboss.as.server.deploymentoverlay.AffectedDeploymentOverlay;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayModel;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentOverlayDeploymentRemoveHandler
extends AbstractRemoveStepHandler {
    public static final AttributeDefinition REDEPLOY_AFFECTED_DEFINITION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"redeploy-affected", (ModelType)ModelType.BOOLEAN).setRequired(false)).setDefaultValue(new ModelNode(false))).build();
    public static final OperationDefinition REMOVE_DEFINITION = new SimpleOperationDefinitionBuilder("remove", ControllerResolver.getResolver((String[])new String[]{"deployment-overlay.deployment"})).addParameter(REDEPLOY_AFFECTED_DEFINITION).build();
    public static final DeploymentOverlayDeploymentRemoveHandler INSTANCE = new DeploymentOverlayDeploymentRemoveHandler();

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String runtimeName = context.getCurrentAddressValue();
        HashSet<PathAddress> removed = (HashSet<PathAddress>)TransformerOperationAttachment.getOrCreate((OperationContext)context).getAttachment(DeploymentOverlayModel.REMOVED_LINKS);
        if (removed == null) {
            removed = new HashSet<PathAddress>();
            TransformerOperationAttachment.getOrCreate((OperationContext)context).attach(DeploymentOverlayModel.REMOVED_LINKS, removed);
        }
        removed.add(context.getCurrentAddress());
        if (REDEPLOY_AFFECTED_DEFINITION.resolveModelAttribute(context, operation).asBoolean()) {
            if ("server-group".equals(context.getCurrentAddress().getElement(0).getKey())) {
                PathAddress overlayAddress = context.getCurrentAddress().getParent();
                OperationStepHandler handler = context.getRootResourceRegistration().getOperationHandler(overlayAddress, "redeploy-links");
                ModelNode redeployAffectedOperation = Util.createOperation((String)"redeploy-links", (PathAddress)overlayAddress);
                redeployAffectedOperation.get("deployments").setEmptyList().add(runtimeName);
                redeployAffectedOperation.get("deployment-overlay-link-removal").set(true);
                assert (handler != null);
                assert (redeployAffectedOperation.isDefined());
                context.addStep(redeployAffectedOperation, handler, OperationContext.Stage.MODEL, true);
                return;
            }
            Set<String> deploymentNames = AffectedDeploymentOverlay.listDeployments(context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS), Collections.singleton(runtimeName));
            AffectedDeploymentOverlay.redeployDeployments(context, PathAddress.EMPTY_ADDRESS, deploymentNames);
        }
        super.performRemove(context, operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    protected final boolean requiresRuntime(OperationContext context) {
        return false;
    }
}

