/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.domain.HostControllerClient;
import org.jboss.as.server.mgmt.domain.HostControllerConnection;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class HostControllerConnectionService
implements Service<HostControllerClient> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "client"});
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    private static final long SERVER_CONNECTION_TIMEOUT = 60000L;
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutorInjector = new InjectedValue();
    private final InjectedValue<Endpoint> endpointInjector = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> processStateServiceInjectedValue = new InjectedValue();
    private final URI connectionURI;
    private final String serverName;
    private final String userName;
    private final String serverProcessName;
    private final String initialAuthKey;
    private final int connectOperationID;
    private final boolean managementSubsystemEndpoint;
    private volatile ResponseAttachmentInputStreamSupport responseAttachmentSupport;
    private final Supplier<SSLContext> sslContextSupplier;
    private HostControllerClient client;

    public HostControllerConnectionService(URI connectionURI, String serverName, String serverProcessName, String authKey, int connectOperationID, boolean managementSubsystemEndpoint, Supplier<SSLContext> sslContextSupplier) {
        this.connectionURI = connectionURI;
        this.serverName = serverName;
        this.userName = "=" + serverName;
        this.serverProcessName = serverProcessName;
        this.initialAuthKey = authKey;
        this.connectOperationID = connectOperationID;
        this.managementSubsystemEndpoint = managementSubsystemEndpoint;
        this.sslContextSupplier = sslContextSupplier != null ? sslContextSupplier : HostControllerConnectionService::getAcceptingSSLContext;
    }

    public synchronized void start(StartContext context) throws StartException {
        Endpoint endpoint = (Endpoint)this.endpointInjector.getValue();
        try {
            ProtocolConnectionConfiguration configuration = ProtocolConnectionConfiguration.create((Endpoint)endpoint, (URI)this.connectionURI, (OptionMap)OptionMap.EMPTY);
            configuration.setConnectionTimeout(60000L);
            configuration.setSslContext(this.sslContextSupplier.get());
            this.responseAttachmentSupport = new ResponseAttachmentInputStreamSupport((ScheduledExecutorService)this.scheduledExecutorInjector.getValue());
            final HostControllerConnection connection = new HostControllerConnection(this.serverProcessName, this.userName, this.connectOperationID, configuration, this.responseAttachmentSupport, (ExecutorService)this.executorInjector.getValue());
            ControlledProcessStateService processService = (ControlledProcessStateService)this.processStateServiceInjectedValue.getValue();
            processService.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ControlledProcessState.State old = (ControlledProcessState.State)evt.getOldValue();
                    ControlledProcessState.State current = (ControlledProcessState.State)evt.getNewValue();
                    if (old == ControlledProcessState.State.STARTING) {
                        if (current == ControlledProcessState.State.RUNNING || current == ControlledProcessState.State.RESTART_REQUIRED) {
                            connection.started();
                        } else {
                            IoUtils.safeClose((Closeable)((Object)connection));
                        }
                    }
                }
            });
            this.client = new HostControllerClient(this.serverName, connection.getChannelHandler(), connection, this.managementSubsystemEndpoint, (ExecutorService)this.executorInjector.getValue());
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext stopContext) {
        ExecutorService executorService = (ExecutorService)this.executorInjector.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    HostControllerConnectionService.this.responseAttachmentSupport.shutdown();
                }
                finally {
                    StreamUtils.safeClose((Closeable)HostControllerConnectionService.this.client);
                    HostControllerConnectionService.this.client = null;
                    stopContext.complete();
                }
            }
        };
        try {
            executorService.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            stopContext.asynchronous();
        }
    }

    public synchronized HostControllerClient getValue() throws IllegalStateException, IllegalArgumentException {
        HostControllerClient client = this.client;
        if (client == null) {
            throw new IllegalStateException();
        }
        return client;
    }

    public InjectedValue<ControlledProcessStateService> getProcessStateServiceInjectedValue() {
        return this.processStateServiceInjectedValue;
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointInjector;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executorInjector;
    }

    public InjectedValue<ScheduledExecutorService> getScheduledExecutorInjector() {
        return this.scheduledExecutorInjector;
    }

    private static SSLContext getAcceptingSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            sslContext.init(null, trustManagers, null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw ServerLogger.ROOT_LOGGER.unableToInitialiseSSLContext(e.getMessage());
        }
    }

    public static class SSLContextSupplier
    implements Supplier<SSLContext>,
    Serializable {
        private final String sslProtocol;
        private final String trustManagerAlgorithm;
        private final String trustStoreType;
        private final String trustStorePath;
        private final char[] trustStorePassword;

        public SSLContextSupplier(String sslProtocol, String trustManagerAlgorithm, String trustStoreType, String trustStorePath, char[] trustStorePassword) {
            this.sslProtocol = sslProtocol;
            this.trustManagerAlgorithm = trustManagerAlgorithm;
            this.trustStoreType = trustStoreType;
            this.trustStorePath = trustStorePath;
            this.trustStorePassword = trustStorePassword;
        }

        @Override
        public SSLContext get() {
            try {
                if ("Default".equals(this.sslProtocol)) {
                    return SSLContext.getDefault();
                }
                KeyStore keyStore = KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
                if (this.trustStorePath != null) {
                    try (FileInputStream fis = new FileInputStream(this.trustStorePath);){
                        keyStore.load(fis, this.trustStorePassword);
                    }
                } else {
                    keyStore.load(null, this.trustStorePassword);
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.trustManagerAlgorithm != null ? this.trustManagerAlgorithm : TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                SSLContext sslContext = SSLContext.getInstance(this.sslProtocol);
                sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
                return sslContext;
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw ServerLogger.ROOT_LOGGER.unableToInitialiseSSLContext(e.getMessage());
            }
        }
    }
}

