/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

class LocalCallbackHandlerService
implements Service<CallbackHandlerService>,
CallbackHandlerService {
    private static final String SERVICE_SUFFIX = "local";
    private final String defaultUser;
    private final String allowedUsers;
    private boolean allowAll;
    private final Set<String> allowedUsersSet = new HashSet<String>();
    private final boolean skipGroupLoading;

    LocalCallbackHandlerService(String defaultUser, String allowedUsers, boolean skipGroupLoading) {
        this.defaultUser = defaultUser;
        this.allowedUsers = allowedUsers;
        this.skipGroupLoading = skipGroupLoading;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.LOCAL;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        if (this.defaultUser != null) {
            return Collections.singletonMap("org.jboss.as.domain.management.local.default_user", this.defaultUser);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        return false;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return new LocalCallbackHander(sharedState);
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new LocalSecurityRealm();
    }

    @Override
    public boolean allowGroupLoading() {
        return !this.skipGroupLoading;
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        if (this.defaultUser != null) {
            this.allowedUsersSet.add(this.defaultUser);
        }
        if (this.allowedUsers != null) {
            if ("*".equals(this.allowedUsers)) {
                this.allowAll = true;
            } else {
                String[] users;
                for (String current : users = this.allowedUsers.split(",")) {
                    this.allowedUsersSet.add(current);
                }
            }
        }
    }

    public void stop(StopContext context) {
        this.allowAll = false;
        this.allowedUsersSet.clear();
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{LocalCallbackHandlerService.SERVICE_SUFFIX});
        }
    }

    private final class LocalCallbackHander
    implements CallbackHandler {
        private final Map<String, Object> sharedState;

        private LocalCallbackHander(Map<String, Object> sharedState) {
            this.sharedState = sharedState;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    String userName = ncb.getDefaultName();
                    if (LocalCallbackHandlerService.this.allowAll || LocalCallbackHandlerService.this.allowedUsersSet.contains(userName)) continue;
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Username '%s' is not permitted for local authentication.", userName);
                    throw DomainManagementLogger.ROOT_LOGGER.invalidLocalUser(userName);
                }
                if (current instanceof AuthorizeCallback) {
                    AuthorizeCallback acb = (AuthorizeCallback)current;
                    boolean authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
                    if (!authorized) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
                    }
                    acb.setAuthorized(authorized);
                    if (!authorized || !LocalCallbackHandlerService.this.skipGroupLoading) continue;
                    this.sharedState.put(SecurityRealmService.SKIP_GROUP_LOADING_KEY, Boolean.TRUE);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }

    private class LocalSecurityRealm
    implements SecurityRealm {
        private LocalSecurityRealm() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            String name = principal.getName();
            if (LocalCallbackHandlerService.this.allowAll || LocalCallbackHandlerService.this.allowedUsersSet.contains(name)) {
                return new LocalRealmIdentity(principal);
            }
            return RealmIdentity.NON_EXISTENT;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        private class LocalRealmIdentity
        implements RealmIdentity {
            private final Principal principal;

            LocalRealmIdentity(Principal principal) {
                this.principal = principal;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return LocalSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName);
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return LocalSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return LocalSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return false;
            }

            public boolean exists() throws RealmUnavailableException {
                return true;
            }
        }
    }
}

