/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;

public final class CredentialStoreCredentialSource
implements CredentialSource {
    private final SecurityFactory<CredentialStore> credentialStoreFactory;
    private final String alias;

    public CredentialStoreCredentialSource(SecurityFactory<CredentialStore> credentialStoreFactory, String alias) {
        Assert.checkNotNullParam((String)"credentialStoreFactory", credentialStoreFactory);
        Assert.checkNotNullParam((String)"alias", (Object)alias);
        this.credentialStoreFactory = credentialStoreFactory;
        this.alias = alias;
    }

    public CredentialStoreCredentialSource(CredentialStore credentialStore, String alias) {
        this(new FixedSecurityFactory<Object>(Assert.checkNotNullParam((String)"credentialStore", (Object)credentialStore)), alias);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        try {
            CredentialStore credentialStore = this.credentialStoreFactory.create();
            return credentialStore.exists(this.alias, credentialType) ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
        }
        catch (UnsupportedCredentialTypeException e) {
            return SupportLevel.UNSUPPORTED;
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.unableToReadCredential(e);
        }
    }

    @Override
    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        try {
            return this.credentialStoreFactory.create().retrieve(this.alias, credentialType, algorithmName, parameterSpec);
        }
        catch (UnsupportedCredentialTypeException e) {
            return null;
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.unableToReadCredential(e);
        }
    }
}

