/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.oauth2;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.MechanismUtil;
import org.wildfly.security.mechanism.oauth2.OAuth2InitialClientMessage;
import org.wildfly.security.sasl.util.StringPrep;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;

public class OAuth2Client {
    private static final String KV_DELIMITER = "%x01";
    private final String mechanismName;
    private final CallbackHandler callbackHandler;
    private final String authorizationId;

    public OAuth2Client(String mechanismName, String authorizationId, CallbackHandler callbackHandler) {
        this.mechanismName = mechanismName;
        this.authorizationId = authorizationId;
        this.callbackHandler = callbackHandler;
    }

    public OAuth2InitialClientMessage getInitialResponse() throws AuthenticationMechanismException {
        CredentialCallback credentialCallback = new CredentialCallback(BearerTokenCredential.class);
        try {
            MechanismUtil.handleCallbacks(this.mechanismName, this.callbackHandler, credentialCallback);
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.log.mechCallbackHandlerDoesNotSupportUserName(this.mechanismName, e);
        }
        Assert.assertTrue((boolean)credentialCallback.isCredentialTypeSupported(BearerTokenCredential.class));
        String token = credentialCallback.applyToCredential(BearerTokenCredential.class, BearerTokenCredential::getToken);
        if (token == null) {
            throw ElytronMessages.log.mechNoTokenGiven(this.mechanismName);
        }
        ByteStringBuilder encoded = new ByteStringBuilder();
        encoded.append("n").append(",");
        if (this.authorizationId != null) {
            encoded.append('a').append('=');
            StringPrep.encode(this.authorizationId, encoded, 1073758207L);
        }
        encoded.append(",").append(KV_DELIMITER).append("auth").append("=").append("Bearer").append(" ").append(token).append(KV_DELIMITER);
        return new OAuth2InitialClientMessage(null, null, encoded.toArray());
    }

    public byte[] handleServerResponse(byte[] serverMessage) {
        if (serverMessage.length == 0) {
            return null;
        }
        try {
            String errorMessage = ByteIterator.ofBytes(serverMessage).base64Decode().asUtf8String().drainToString();
            ElytronMessages.log.debugf("Got error message from server [%s].", errorMessage);
        }
        catch (Exception e) {
            ElytronMessages.log.errorf(e, "Server returned an unexpected message that is probably an error but could not be parsed.", new Object[0]);
        }
        return new ByteStringBuilder().append(KV_DELIMITER).toArray();
    }
}

