/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.undertow.HttpListenerAdd;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.xnio.Option;

public class HttpListenerResourceDefinition
extends ListenerResourceDefinition {
    protected static final HttpListenerResourceDefinition INSTANCE = new HttpListenerResourceDefinition();
    protected static final SimpleAttributeDefinition CERTIFICATE_FORWARDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("certificate-forwarding", ModelType.BOOLEAN).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition PROXY_ADDRESS_FORWARDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("proxy-address-forwarding", ModelType.BOOLEAN).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    protected static final OptionAttributeDefinition ENABLE_HTTP2 = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"enable-http2", (Option)UndertowOptions.ENABLE_HTTP2).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final OptionAttributeDefinition HTTP2_ENABLE_PUSH = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-enable-push", (Option)UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    protected static final OptionAttributeDefinition HTTP2_HEADER_TABLE_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-header-table-size", (Option)UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setDefaultValue(new ModelNode(4096))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    protected static final OptionAttributeDefinition HTTP2_INITIAL_WINDOW_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-initial-window-size", (Option)UndertowOptions.HTTP2_SETTINGS_INITIAL_WINDOW_SIZE).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setDefaultValue(new ModelNode(65535))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    protected static final OptionAttributeDefinition HTTP2_MAX_CONCURRENT_STREAMS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-max-concurrent-streams", (Option)UndertowOptions.HTTP2_SETTINGS_MAX_CONCURRENT_STREAMS).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    protected static final OptionAttributeDefinition HTTP2_MAX_FRAME_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-max-frame-size", (Option)UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setDefaultValue(new ModelNode(16384))).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    protected static final OptionAttributeDefinition HTTP2_MAX_HEADER_LIST_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"http2-max-header-list-size", (Option)UndertowOptions.HTTP2_SETTINGS_MAX_HEADER_LIST_SIZE).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.BYTES)).setValidator((ParameterValidator)new IntRangeValidator(1))).build();
    protected static final OptionAttributeDefinition REQUIRE_HOST_HTTP11 = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"require-host-http11", (Option)UndertowOptions.REQUIRE_HOST_HTTP11).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();

    private HttpListenerResourceDefinition() {
        super(UndertowExtension.HTTP_LISTENER_PATH);
    }

    @Override
    protected ListenerAdd getAddHandler() {
        return new HttpListenerAdd(this);
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        ArrayList<AttributeDefinition> attrs = new ArrayList<AttributeDefinition>(super.getAttributes());
        attrs.add((AttributeDefinition)CERTIFICATE_FORWARDING);
        attrs.add((AttributeDefinition)REDIRECT_SOCKET);
        attrs.add((AttributeDefinition)PROXY_ADDRESS_FORWARDING);
        attrs.add((AttributeDefinition)ENABLE_HTTP2);
        attrs.add((AttributeDefinition)HTTP2_ENABLE_PUSH);
        attrs.add((AttributeDefinition)HTTP2_HEADER_TABLE_SIZE);
        attrs.add((AttributeDefinition)HTTP2_INITIAL_WINDOW_SIZE);
        attrs.add((AttributeDefinition)HTTP2_MAX_CONCURRENT_STREAMS);
        attrs.add((AttributeDefinition)HTTP2_MAX_HEADER_LIST_SIZE);
        attrs.add((AttributeDefinition)HTTP2_MAX_FRAME_SIZE);
        attrs.add((AttributeDefinition)REQUIRE_HOST_HTTP11);
        return attrs;
    }
}

