/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.CodePointIterator;
import org.wildfly.security.util._private.Arrays2;

class NonceManager {
    private static final int PREFIX_LENGTH = 12;
    private final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1);
    private final AtomicInteger nonceCounter = new AtomicInteger();
    private final Set<String> usedNonces = new HashSet<String>();
    private final byte[] privateKey;
    private final long validityPeriodNano;
    private final boolean singleUse;
    private final String algorithm;

    NonceManager(long validityPeriod, boolean singleUse, int keySize, String algorithm) {
        this.validityPeriodNano = validityPeriod * 1000000L;
        this.singleUse = singleUse;
        this.algorithm = algorithm;
        this.privateKey = new byte[keySize];
        new SecureRandom().nextBytes(this.privateKey);
    }

    String generateNonce() {
        return this.generateNonce(null);
    }

    String generateNonce(byte[] salt) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            ByteBuffer byteBuffer = ByteBuffer.allocate(12 + messageDigest.getDigestLength());
            byteBuffer.putInt(this.nonceCounter.incrementAndGet());
            byteBuffer.putLong(System.nanoTime());
            byteBuffer.put(this.digest(byteBuffer.array(), 0, 12, salt, messageDigest));
            String nonce = ByteIterator.ofBytes(byteBuffer.array()).base64Encode().drainToString();
            if (ElytronMessages.log.isTraceEnabled()) {
                String saltString = salt == null ? "null" : ByteIterator.ofBytes(salt).hexEncode().drainToString();
                ElytronMessages.log.tracef("New nonce generated %s, using seed %s", (Object)nonce, (Object)saltString);
            }
            return nonce;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] digest(byte[] prefix, int prefixOffset, int prefixLength, byte[] salt, MessageDigest messageDigest) throws DigestException {
        messageDigest.update(prefix, prefixOffset, prefixLength);
        if (salt != null) {
            messageDigest.update(salt);
        }
        return messageDigest.digest(this.privateKey);
    }

    boolean useNonce(String nonce) throws AuthenticationMechanismException {
        return this.useNonce(nonce, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useNonce(String nonce, byte[] salt) throws AuthenticationMechanismException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            ByteIterator byteIterator = CodePointIterator.ofChars(nonce.toCharArray()).base64Decode();
            byte[] nonceBytes = byteIterator.drain();
            if (nonceBytes.length != 12 + messageDigest.getDigestLength()) {
                throw ElytronMessages.log.invalidNonceLength("DIGEST");
            }
            long age = System.nanoTime() - ByteBuffer.wrap(nonceBytes, 4, 8).getLong();
            if (age < 0L || age > this.validityPeriodNano) {
                ElytronMessages.log.tracef("Nonce %s rejected due to age %d (ns) being less than 0 or greater than the validity period %d (ns)", (Object)nonce, (Object)age, (Object)this.validityPeriodNano);
                return false;
            }
            if (!Arrays2.equals(nonceBytes, 12, this.digest(nonceBytes, 0, 12, salt, messageDigest))) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    String saltString = salt == null ? "null" : ByteIterator.ofBytes(salt).hexEncode().drainToString();
                    ElytronMessages.log.tracef("Nonce %s rejected due to failed comparison using secret key with seed %s.", (Object)nonce, (Object)saltString);
                }
                return false;
            }
            if (this.singleUse) {
                Set<String> set = this.usedNonces;
                synchronized (set) {
                    boolean used = this.usedNonces.add(nonce);
                    if (used) {
                        this.executor.schedule(() -> {
                            Set<String> set = this.usedNonces;
                            synchronized (set) {
                                this.usedNonces.remove(nonce);
                            }
                        }, this.validityPeriodNano - age, TimeUnit.MILLISECONDS);
                    } else {
                        ElytronMessages.log.tracef("Nonce %s rejected as previously used.", (Object)nonce);
                    }
                    return used;
                }
            }
            return true;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

