/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.CredentialStoreCommand;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.tool.MaskCommand;
import org.wildfly.security.tool.VaultCommand;

public class ElytronTool {
    public static int ElytronToolExitStatus_unrecognizedCommand = 1;
    public static int ElytronToolExitStatus_OK = 0;
    public static final String TOOL_JAR = "wildfly-elytron-tool.jar";
    private Map<String, Command> commandRegistry = new HashMap<String, Command>();

    public ElytronTool() {
        this.commandRegistry.put("credential-store", new CredentialStoreCommand());
        this.commandRegistry.put("mask", new MaskCommand());
        this.commandRegistry.put("vault", new VaultCommand());
    }

    public static void main(String[] args) {
        Security.addProvider(new WildFlyElytronProvider());
        ElytronTool tool = new ElytronTool();
        if (args != null && args.length > 0) {
            Command command = tool.findCommand(args[0]);
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            if (command != null && newArgs.length > 0) {
                try {
                    command.execute(newArgs);
                    System.exit(command.getStatus());
                }
                catch (Exception e) {
                    if (command.isEnableDebug()) {
                        System.err.println(ElytronToolMessages.msg.commandExecuteException());
                        e.printStackTrace(System.err);
                    } else if (e.getLocalizedMessage() != null && e.getLocalizedMessage().startsWith("ELYTOOL")) {
                        System.err.println(ElytronToolMessages.msg.commandExecuteException());
                        System.err.println(e.getLocalizedMessage());
                    } else {
                        System.err.println(ElytronToolMessages.msg.commandExecuteExceptionNoDebug());
                    }
                    System.exit(command.getStatus());
                }
            } else if ("--help".equals(args[0]) || "-h".equals(args[0]) || command != null && newArgs.length == 0) {
                if (command != null) {
                    command.help();
                } else {
                    tool.generalHelp();
                }
            } else {
                System.err.println(ElytronToolMessages.msg.commandOrAliasNotFound(args[0]));
                System.exit(ElytronToolExitStatus_unrecognizedCommand);
            }
        } else {
            tool.generalHelp();
        }
    }

    private void generalHelp() {
        System.out.print(ElytronToolMessages.msg.missingArgumentsHelp());
        System.out.println();
        for (Command c : this.commandRegistry.values()) {
            c.help();
            System.out.println();
        }
    }

    Command findCommand(String commandName) {
        Command command = this.commandRegistry.get(commandName);
        if (command != null) {
            return command;
        }
        for (Command c : this.commandRegistry.values()) {
            if (!c.isAlias(commandName)) continue;
            return c;
        }
        return null;
    }
}

