/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBClientContextService;
import org.jboss.as.ejb3.remote.LocalTransportProvider;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.ejb3.subsystem.EJBClientConfiguratorService;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientCluster;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.modules.Module;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.MatchRule;
import org.xnio.Option;
import org.xnio.OptionMap;

public class EJBClientDescriptorMetaDataProcessor
implements DeploymentUnitProcessor {
    private static final String INTERNAL_REMOTING_PROFILE = "internal-remoting-profile";
    private final boolean appclient;

    public EJBClientDescriptorMetaDataProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ServiceName profileServiceName;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        EJBClientDescriptorMetaData ejbClientDescriptorMetaData = (EJBClientDescriptorMetaData)deploymentUnit.getAttachment(org.jboss.as.ee.structure.Attachments.EJB_CLIENT_METADATA);
        if (ejbClientDescriptorMetaData == null) {
            return;
        }
        this.checkDescriptorConfiguration(ejbClientDescriptorMetaData);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        ServiceName ejbClientContextServiceName = EJBClientContextService.DEPLOYMENT_BASE_SERVICE_NAME.append(new String[]{deploymentUnit.getName()});
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        final EJBClientContextService service = new EJBClientContextService();
        ServiceBuilder serviceBuilder = serviceTarget.addService(ejbClientContextServiceName, (Service)service);
        if (this.appclient) {
            serviceBuilder.addDependency(EJBClientContextService.APP_CLIENT_URI_SERVICE_NAME, URI.class, service.getAppClientUri());
            serviceBuilder.addDependency(EJBClientContextService.APP_CLIENT_EJB_PROPERTIES_SERVICE_NAME, String.class, service.getAppClientEjbProperties());
        }
        serviceBuilder.addDependency(EJBClientConfiguratorService.SERVICE_NAME, EJBClientConfiguratorService.class, service.getConfiguratorServiceInjector());
        Injector<RemotingProfileService> profileServiceInjector = new Injector<RemotingProfileService>(){
            final Injector<EJBTransportProvider> injector;
            boolean injected;
            {
                this.injector = service.getLocalProviderInjector();
                this.injected = false;
            }

            public void inject(RemotingProfileService value) throws InjectionException {
                EJBTransportProvider provider = (EJBTransportProvider)value.getLocalTransportProviderInjector().getOptionalValue();
                if (provider != null) {
                    this.injected = true;
                    this.injector.inject((Object)provider);
                }
            }

            public void uninject() {
                if (this.injected) {
                    this.injected = false;
                    this.injector.uninject();
                }
            }
        };
        String profile = ejbClientDescriptorMetaData.getProfile();
        if (profile != null) {
            profileServiceName = RemotingProfileService.BASE_SERVICE_NAME.append(new String[]{profile});
            serviceBuilder.addDependency(profileServiceName, RemotingProfileService.class, (Injector)profileServiceInjector);
            serviceBuilder.addDependency(profileServiceName, RemotingProfileService.class, service.getProfileServiceInjector());
        } else {
            profileServiceName = ejbClientContextServiceName.append(new String[]{INTERNAL_REMOTING_PROFILE});
            HashMap<String, RemotingProfileService.ConnectionSpec> map = new HashMap<String, RemotingProfileService.ConnectionSpec>();
            RemotingProfileService profileService = new RemotingProfileService(Collections.emptyList(), map);
            ServiceBuilder profileServiceBuilder = serviceTarget.addService(profileServiceName, (Service)profileService);
            if (ejbClientDescriptorMetaData.isLocalReceiverExcluded() != Boolean.TRUE) {
                Boolean passByValue = ejbClientDescriptorMetaData.isLocalReceiverPassByValue();
                profileServiceBuilder.addDependency(passByValue == Boolean.TRUE ? LocalTransportProvider.BY_VALUE_SERVICE_NAME : LocalTransportProvider.BY_REFERENCE_SERVICE_NAME, EJBTransportProvider.class, profileService.getLocalTransportProviderInjector());
            }
            Collection receiverConfigurations = ejbClientDescriptorMetaData.getRemotingReceiverConfigurations();
            for (EJBClientDescriptorMetaData.RemotingReceiverConfiguration receiverConfiguration : receiverConfigurations) {
                String connectionRef = receiverConfiguration.getOutboundConnectionRef();
                long connectTimeout = receiverConfiguration.getConnectionTimeout();
                Properties channelCreationOptions = receiverConfiguration.getChannelCreationOptions();
                OptionMap optionMap = this.getOptionMapFromProperties(channelCreationOptions, EJBClientDescriptorMetaDataProcessor.class.getClassLoader());
                InjectedValue injector = new InjectedValue();
                profileServiceBuilder.addDependency(AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionRef}), AbstractOutboundConnectionService.class, (Injector)injector);
                RemotingProfileService.ConnectionSpec connectionSpec = new RemotingProfileService.ConnectionSpec(connectionRef, (InjectedValue<AbstractOutboundConnectionService>)injector, optionMap, connectTimeout);
                map.put(connectionRef, connectionSpec);
            }
            profileServiceBuilder.install();
            serviceBuilder.addDependency(profileServiceName, RemotingProfileService.class, (Injector)profileServiceInjector);
            serviceBuilder.addDependency(profileServiceName, RemotingProfileService.class, service.getProfileServiceInjector());
        }
        String deploymentNodeSelectorClassName = ejbClientDescriptorMetaData.getDeploymentNodeSelector();
        if (deploymentNodeSelectorClassName != null) {
            DeploymentNodeSelector deploymentNodeSelector;
            try {
                deploymentNodeSelector = module.getClassLoader().loadClass(deploymentNodeSelectorClassName).asSubclass(DeploymentNodeSelector.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw EjbLogger.ROOT_LOGGER.failedToCreateDeploymentNodeSelector(e, deploymentNodeSelectorClassName);
            }
            service.setDeploymentNodeSelector(deploymentNodeSelector);
        }
        long invocationTimeout = ejbClientDescriptorMetaData.getInvocationTimeout();
        service.setInvocationTimeout(invocationTimeout);
        Collection clusterConfigs = ejbClientDescriptorMetaData.getClusterConfigs();
        if (!clusterConfigs.isEmpty()) {
            ArrayList<EJBClientCluster> clientClusters = new ArrayList<EJBClientCluster>(clusterConfigs.size());
            AuthenticationContext clustersAuthenticationContext = AuthenticationContext.empty();
            for (EJBClientDescriptorMetaData.ClusterConfig clusterConfig : clusterConfigs) {
                MatchRule defaultRule = MatchRule.ALL.matchAbstractType("ejb", "jboss");
                AuthenticationConfiguration defaultAuthenticationConfiguration = AuthenticationConfiguration.EMPTY;
                EJBClientCluster.Builder clientClusterBuilder = new EJBClientCluster.Builder();
                String clusterName = clusterConfig.getClusterName();
                clientClusterBuilder.setName(clusterName);
                defaultRule = defaultRule.matchProtocol("cluster");
                defaultRule = defaultRule.matchUrnName(clusterName);
                long maxAllowedConnectedNodes = clusterConfig.getMaxAllowedConnectedNodes();
                clientClusterBuilder.setMaximumConnectedNodes(maxAllowedConnectedNodes);
                String clusterNodeSelectorClassName = clusterConfig.getNodeSelector();
                if (clusterNodeSelectorClassName != null) {
                    ClusterNodeSelector clusterNodeSelector;
                    try {
                        clusterNodeSelector = module.getClassLoader().loadClass(clusterNodeSelectorClassName).asSubclass(ClusterNodeSelector.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw EjbLogger.ROOT_LOGGER.failureDuringLoadOfClusterNodeSelector(clusterNodeSelectorClassName, clusterName, e);
                    }
                    clientClusterBuilder.setClusterNodeSelector(clusterNodeSelector);
                }
                Properties clusterChannelCreationOptions = clusterConfig.getChannelCreationOptions();
                OptionMap clusterChannelCreationOptionMap = this.getOptionMapFromProperties(clusterChannelCreationOptions, EJBClientDescriptorMetaDataProcessor.class.getClassLoader());
                Properties clusterConnectionOptions = clusterConfig.getConnectionOptions();
                OptionMap clusterConnectionOptionMap = this.getOptionMapFromProperties(clusterConnectionOptions, EJBClientDescriptorMetaDataProcessor.class.getClassLoader());
                long clusterConnectTimeout = clusterConfig.getConnectTimeout();
                clientClusterBuilder.setConnectTimeoutMilliseconds(clusterConnectTimeout);
                String clusterSecurityRealm = clusterConfig.getSecurityRealm();
                String clusterUserName = clusterConfig.getUserName();
                CallbackHandler callbackHandler = this.getCallbackHandler(phaseContext.getServiceRegistry(), clusterUserName, clusterSecurityRealm);
                if (callbackHandler != null) {
                    defaultAuthenticationConfiguration = defaultAuthenticationConfiguration.useCallbackHandler(callbackHandler);
                }
                if (clusterConnectionOptionMap != null) {
                    RemotingOptions.mergeOptionsIntoAuthenticationConfiguration((OptionMap)clusterConnectionOptionMap, (AuthenticationConfiguration)defaultAuthenticationConfiguration);
                }
                clustersAuthenticationContext = clustersAuthenticationContext.with(defaultRule, defaultAuthenticationConfiguration);
                Collection clusterNodeConfigs = clusterConfig.getClusterNodeConfigs();
                for (EJBClientDescriptorMetaData.ClusterNodeConfig clusterNodeConfig : clusterNodeConfigs) {
                    MatchRule nodeRule = MatchRule.ALL.matchAbstractType("ejb", "jboss");
                    AuthenticationConfiguration nodeAuthenticationConfiguration = AuthenticationConfiguration.EMPTY;
                    String nodeName = clusterNodeConfig.getNodeName();
                    nodeRule = nodeRule.matchProtocol("node");
                    nodeRule = nodeRule.matchUrnName(nodeName);
                    Properties channelCreationOptions = clusterNodeConfig.getChannelCreationOptions();
                    Properties connectionOptions = clusterNodeConfig.getConnectionOptions();
                    OptionMap connectionOptionMap = this.getOptionMapFromProperties(connectionOptions, EJBClientDescriptorMetaDataProcessor.class.getClassLoader());
                    long connectTimeout = clusterNodeConfig.getConnectTimeout();
                    String securityRealm = clusterNodeConfig.getSecurityRealm();
                    String userName = clusterNodeConfig.getUserName();
                    CallbackHandler nodeCallbackHandler = this.getCallbackHandler(phaseContext.getServiceRegistry(), userName, securityRealm);
                    if (nodeCallbackHandler != null) {
                        nodeAuthenticationConfiguration = nodeAuthenticationConfiguration.useCallbackHandler(nodeCallbackHandler);
                    }
                    if (connectionOptionMap != null) {
                        RemotingOptions.mergeOptionsIntoAuthenticationConfiguration((OptionMap)connectionOptionMap, (AuthenticationConfiguration)nodeAuthenticationConfiguration);
                    }
                    clustersAuthenticationContext = clustersAuthenticationContext.with(0, nodeRule, nodeAuthenticationConfiguration);
                }
                EJBClientCluster clientCluster = clientClusterBuilder.build();
                clientClusters.add(clientCluster);
            }
            service.setClientClusters(clientClusters);
            service.setClustersAuthenticationContext(clustersAuthenticationContext);
        }
        serviceBuilder.install();
        EjbLogger.DEPLOYMENT_LOGGER.debugf("Deployment unit %s will use %s as the EJB client context service", deploymentUnit, ejbClientContextServiceName);
        phaseContext.addDeploymentDependency(ejbClientContextServiceName, EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE);
        deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_CLIENT_CONTEXT_SERVICE_NAME, (Object)ejbClientContextServiceName);
        deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_REMOTING_PROFILE_SERVICE_NAME, (Object)profileServiceName);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void checkDescriptorConfiguration(EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws DeploymentUnitProcessingException {
        boolean receiversDefined;
        boolean profileDefined = ejbClientDescriptorMetaData.getProfile() != null;
        boolean bl = receiversDefined = !ejbClientDescriptorMetaData.getRemotingReceiverConfigurations().isEmpty() || ejbClientDescriptorMetaData.isLocalReceiverExcluded() != null || ejbClientDescriptorMetaData.isLocalReceiverPassByValue() != null;
        if (profileDefined && receiversDefined) {
            throw EjbLogger.ROOT_LOGGER.profileAndRemotingEjbReceiversUsedTogether();
        }
    }

    private OptionMap getOptionMapFromProperties(Properties properties, ClassLoader classLoader) {
        OptionMap.Builder optionMapBuilder = OptionMap.builder();
        if (properties != null) {
            for (String propertyName : properties.stringPropertyNames()) {
                try {
                    Option option = Option.fromString((String)propertyName, (ClassLoader)classLoader);
                    optionMapBuilder.parse(option, properties.getProperty(propertyName), classLoader);
                }
                catch (IllegalArgumentException e) {
                    EjbLogger.DEPLOYMENT_LOGGER.failedToCreateOptionForProperty(propertyName, e.getMessage());
                }
            }
        }
        return optionMapBuilder.getMap();
    }

    private CallbackHandler getCallbackHandler(ServiceRegistry serviceRegistry, String userName, String securityRealmName) {
        CallbackHandlerFactory cbhFactory;
        SecurityRealm securityRealm;
        ServiceName securityRealmServiceName;
        ServiceController securityRealmController;
        if (securityRealmName != null && !securityRealmName.trim().isEmpty() && (securityRealmController = serviceRegistry.getService(securityRealmServiceName = SecurityRealm.ServiceUtil.createServiceName((String)securityRealmName))) != null && (securityRealm = (SecurityRealm)securityRealmController.getValue()) != null && (cbhFactory = securityRealm.getSecretCallbackHandlerFactory()) != null && userName != null) {
            return cbhFactory.getCallbackHandler(userName);
        }
        return null;
    }
}

