/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.QuotedPrintableInputStream;
import org.apache.james.mime4j.util.CharsetUtil;

public class DecoderUtil {
    private static Log log = LogFactory.getLog(DecoderUtil.class);

    public static byte[] decodeBaseQuotedPrintable(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            QuotedPrintableInputStream is = new QuotedPrintableInputStream(new ByteArrayInputStream(bytes));
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return baos.toByteArray();
    }

    public static byte[] decodeBase64(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] bytes = s.getBytes("US-ASCII");
            Base64InputStream is = new Base64InputStream(new ByteArrayInputStream(bytes));
            int b = 0;
            while ((b = is.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return baos.toByteArray();
    }

    public static String decodeB(String encodedWord, String charset) throws UnsupportedEncodingException {
        return new String(DecoderUtil.decodeBase64(encodedWord), charset);
    }

    public static String decodeQ(String encodedWord, String charset) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < encodedWord.length(); ++i) {
            char c = encodedWord.charAt(i);
            if (c == '_') {
                sb.append("=20");
                continue;
            }
            sb.append(c);
        }
        return new String(DecoderUtil.decodeBaseQuotedPrintable(sb.toString()), charset);
    }

    public static String decodeEncodedWords(String body) {
        int previousEnd = 0;
        boolean previousWasEncoded = false;
        StringBuilder sb = new StringBuilder();
        while (true) {
            int begin;
            int end;
            int n = end = (begin = body.indexOf("=?", previousEnd)) == -1 ? -1 : body.indexOf("?=", begin + 2);
            if (end == -1) {
                if (previousEnd == 0) {
                    return body;
                }
                sb.append(body.substring(previousEnd));
                return sb.toString();
            }
            String sep = body.substring(previousEnd, begin);
            String decoded = DecoderUtil.decodeEncodedWord(body, begin, end += 2);
            if (decoded == null) {
                sb.append(sep);
                sb.append(body.substring(begin, end));
            } else {
                if (!previousWasEncoded || !CharsetUtil.isWhitespace(sep)) {
                    sb.append(sep);
                }
                sb.append(decoded);
            }
            previousEnd = end;
            previousWasEncoded = decoded != null;
        }
    }

    private static String decodeEncodedWord(String body, int begin, int end) {
        int qm1 = body.indexOf(63, begin + 2);
        if (qm1 == end - 2) {
            return null;
        }
        int qm2 = body.indexOf(63, qm1 + 1);
        if (qm2 == end - 2) {
            return null;
        }
        String mimeCharset = body.substring(begin + 2, qm1);
        String encoding = body.substring(qm1 + 1, qm2);
        String encodedText = body.substring(qm2 + 1, end - 2);
        String charset = CharsetUtil.toJavaCharset(mimeCharset);
        if (charset == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("MIME charset '" + mimeCharset + "' in encoded word '" + body.substring(begin, end) + "' doesn't have a corresponding Java charset"));
            }
            return null;
        }
        if (!CharsetUtil.isDecodingSupported(charset)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Current JDK doesn't support decoding of charset '" + charset + "' (MIME charset '" + mimeCharset + "' in encoded word '" + body.substring(begin, end) + "')"));
            }
            return null;
        }
        if (encodedText.length() == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Missing encoded text in encoded word: '" + body.substring(begin, end) + "'"));
            }
            return null;
        }
        try {
            if (encoding.equalsIgnoreCase("Q")) {
                return DecoderUtil.decodeQ(encodedText, charset);
            }
            if (encoding.equalsIgnoreCase("B")) {
                return DecoderUtil.decodeB(encodedText, charset);
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("Warning: Unknown encoding in encoded word '" + body.substring(begin, end) + "'"));
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unsupported encoding in encoded word '" + body.substring(begin, end) + "'"), (Throwable)e);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not decode encoded word '" + body.substring(begin, end) + "'"), (Throwable)e);
            }
            return null;
        }
    }
}

