/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterSequence
extends SchemaCommand {
    private boolean ifExists;
    private Table table;
    private String sequenceName;
    private Sequence sequence;
    private Expression start;
    private Expression increment;
    private Boolean cycle;
    private Expression minValue;
    private Expression maxValue;
    private Expression cacheSize;

    public AlterSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void setColumn(Column column) {
        this.table = column.getTable();
        this.sequence = column.getSequence();
        if (this.sequence == null && !this.ifExists) {
            throw DbException.get(90036, column.getSQL());
        }
    }

    public void setStartWith(Expression start) {
        this.start = start;
    }

    public void setIncrement(Expression increment) {
        this.increment = increment;
    }

    public void setCycle(Boolean cycle) {
        this.cycle = cycle;
    }

    public void setMinValue(Expression minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(Expression maxValue) {
        this.maxValue = maxValue;
    }

    public void setCacheSize(Expression cacheSize) {
        this.cacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Session sysSession;
        Database db = this.session.getDatabase();
        if (this.sequence == null) {
            this.sequence = this.getSchema().findSequence(this.sequenceName);
            if (this.sequence == null) {
                if (!this.ifExists) {
                    throw DbException.get(90036, this.sequenceName);
                }
                return 0;
            }
        }
        if (this.table != null) {
            this.session.getUser().checkRight(this.table, 15);
        }
        if (this.cycle != null) {
            this.sequence.setCycle(this.cycle);
        }
        if (this.cacheSize != null) {
            long size = this.cacheSize.optimize(this.session).getValue(this.session).getLong();
            this.sequence.setCacheSize(size);
        }
        if (this.start != null || this.minValue != null || this.maxValue != null || this.increment != null) {
            Long startValue = this.getLong(this.start);
            Long min = this.getLong(this.minValue);
            Long max = this.getLong(this.maxValue);
            Long inc = this.getLong(this.increment);
            this.sequence.modify(startValue, min, max, inc);
        }
        Session session = sysSession = db.getSystemSession();
        synchronized (session) {
            Database database = db;
            synchronized (database) {
                db.updateMeta(sysSession, this.sequence);
                sysSession.commit(true);
            }
        }
        return 0;
    }

    private Long getLong(Expression expr) {
        if (expr == null) {
            return null;
        }
        return expr.optimize(this.session).getValue(this.session).getLong();
    }

    @Override
    public int getType() {
        return 54;
    }
}

