/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public class Merge
extends Prepared {
    private Table table;
    private Column[] columns;
    private Column[] keys;
    private final ArrayList<Expression[]> list = New.arrayList();
    private Query query;
    private Prepared update;

    public Merge(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setKeys(Column[] keys) {
        this.keys = keys;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expr) {
        this.list.add(expr);
    }

    @Override
    public int update() {
        int count;
        this.session.getUser().checkRight(this.table, 4);
        this.session.getUser().checkRight(this.table, 8);
        this.setCurrentRowNumber(0);
        if (this.list.size() > 0) {
            count = 0;
            int size = this.list.size();
            for (int x = 0; x < size; ++x) {
                this.setCurrentRowNumber(x + 1);
                Expression[] expr = this.list.get(x);
                Row newRow = this.table.getTemplateRow();
                int len = this.columns.length;
                for (int i = 0; i < len; ++i) {
                    Column c = this.columns[i];
                    int index = c.getColumnId();
                    Expression e = expr[i];
                    if (e == null) continue;
                    try {
                        Value v = c.convert(e.getValue(this.session));
                        newRow.setValue(index, v);
                        continue;
                    }
                    catch (DbException ex) {
                        throw this.setRow(ex, count, Merge.getSQL(expr));
                    }
                }
                this.merge(newRow);
                ++count;
            }
        } else {
            LocalResult rows = this.query.query(0);
            count = 0;
            this.table.fire(this.session, 3, true);
            this.table.lock(this.session, true, false);
            while (rows.next()) {
                Value[] r = rows.currentRow();
                Row newRow = this.table.getTemplateRow();
                this.setCurrentRowNumber(++count);
                for (int j = 0; j < this.columns.length; ++j) {
                    Column c = this.columns[j];
                    int index = c.getColumnId();
                    try {
                        Value v = c.convert(r[j]);
                        newRow.setValue(index, v);
                        continue;
                    }
                    catch (DbException ex) {
                        throw this.setRow(ex, count, Merge.getSQL(r));
                    }
                }
                this.merge(newRow);
            }
            rows.close();
            this.table.fire(this.session, 3, false);
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(Row row) {
        Parameter p;
        Value v;
        Column col;
        int i;
        ArrayList<Parameter> k = this.update.getParameters();
        for (i = 0; i < this.columns.length; ++i) {
            col = this.columns[i];
            v = row.getValue(col.getColumnId());
            p = k.get(i);
            p.setValue(v);
        }
        for (i = 0; i < this.keys.length; ++i) {
            col = this.keys[i];
            v = row.getValue(col.getColumnId());
            if (v == null) {
                throw DbException.get(90081, col.getSQL());
            }
            p = k.get(this.columns.length + i);
            p.setValue(v);
        }
        int count = this.update.update();
        if (count == 0) {
            try {
                this.table.validateConvertUpdateSequence(this.session, row);
                boolean done = this.table.fireBeforeRow(this.session, null, row);
                if (done) return;
                this.table.lock(this.session, true, false);
                this.table.addRow(this.session, row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row, false);
                return;
            }
            catch (DbException e) {
                Index index;
                if (e.getErrorCode() != 23505 || (index = (Index)e.getSource()) == null) throw e;
                Column[] indexColumns = index.getColumns();
                boolean indexMatchesKeys = false;
                if (indexColumns.length <= this.keys.length) {
                    for (int i2 = 0; i2 < indexColumns.length; ++i2) {
                        if (indexColumns[i2] == this.keys[i2]) continue;
                        indexMatchesKeys = false;
                        break;
                    }
                }
                if (!indexMatchesKeys) throw e;
                throw DbException.get(90131, this.table.getName());
            }
        } else {
            if (count == 1) return;
            throw DbException.get(23505, this.table.getSQL());
        }
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder buff = new StatementBuilder("MERGE INTO ");
        buff.append(this.table.getSQL()).append('(');
        for (Column c : this.columns) {
            buff.appendExceptFirst(", ");
            buff.append(c.getSQL());
        }
        buff.append(')');
        if (this.keys != null) {
            buff.append(" KEY(");
            buff.resetCount();
            for (Column c : this.keys) {
                buff.appendExceptFirst(", ");
                buff.append(c.getSQL());
            }
            buff.append(')');
        }
        buff.append('\n');
        if (this.list.size() > 0) {
            buff.append("VALUES ");
            int row = 0;
            for (Expression[] expr : this.list) {
                if (row++ > 0) {
                    buff.append(", ");
                }
                buff.append('(');
                buff.resetCount();
                for (Expression e : expr) {
                    buff.appendExceptFirst(", ");
                    if (e == null) {
                        buff.append("DEFAULT");
                        continue;
                    }
                    buff.append(e.getSQL());
                }
                buff.append(')');
            }
        } else {
            buff.append(this.query.getPlanSQL());
        }
        return buff.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (Expression[] expressionArray : this.list) {
                if (expressionArray.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i = 0; i < expressionArray.length; ++i) {
                    Expression e = expressionArray[i];
                    if (e == null) continue;
                    expressionArray[i] = e.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            Index idx = this.table.getPrimaryKey();
            if (idx == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = idx.getColumns();
        }
        StatementBuilder buff = new StatementBuilder("UPDATE ");
        buff.append(this.table.getSQL()).append(" SET ");
        for (Column column : this.columns) {
            buff.appendExceptFirst(", ");
            buff.append(column.getSQL()).append("=?");
        }
        buff.append(" WHERE ");
        buff.resetCount();
        for (Column column : this.keys) {
            buff.appendExceptFirst(" AND ");
            buff.append(column.getSQL()).append("=?");
        }
        String string = buff.toString();
        this.update = this.session.prepare(string);
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 62;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }
}

