/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Database;
import org.h2.expression.AggregateData;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

class AggregateDataCount
extends AggregateData {
    private long count;
    private ValueHashMap<AggregateDataCount> distinctValues;

    AggregateDataCount() {
    }

    @Override
    void add(Database database, int dataType, boolean distinct, Value v) {
        if (v == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        if (distinct) {
            if (this.distinctValues == null) {
                this.distinctValues = ValueHashMap.newInstance();
            }
            this.distinctValues.put(v, this);
            return;
        }
    }

    @Override
    Value getValue(Database database, int dataType, boolean distinct) {
        if (distinct) {
            this.count = this.distinctValues != null ? (long)this.distinctValues.size() : 0L;
        }
        ValueLong v = ValueLong.get(this.count);
        return v.convertTo(dataType);
    }
}

